/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.HotkeyHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncHotkeyPacket
implements IMessage {
    private int selectedPart;
    private int key;

    public SyncHotkeyPacket() {
    }

    public SyncHotkeyPacket(int selectedPart, int key) {
        this.selectedPart = selectedPart;
        this.key = key;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.selectedPart);
        buf.writeInt(this.key);
    }

    public void fromBytes(ByteBuf buf) {
        this.selectedPart = buf.readInt();
        this.key = buf.readInt();
    }

    private static class DoSync
    implements Runnable {
        private int selectedPart;
        private int key;
        private EntityPlayer entityPlayer;

        public DoSync(int selectedPart, int key, EntityPlayer entityPlayer) {
            this.selectedPart = selectedPart;
            this.key = key;
            this.entityPlayer = entityPlayer;
        }

        @Override
        public void run() {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)this.entityPlayer);
            if (cyberwareUserData != null) {
                if (this.key == Integer.MAX_VALUE) {
                    HotkeyHelper.removeHotkey(cyberwareUserData, cyberwareUserData.getActiveItems().get(this.selectedPart));
                } else {
                    HotkeyHelper.removeHotkey(cyberwareUserData, this.key);
                    HotkeyHelper.assignHotkey(cyberwareUserData, cyberwareUserData.getActiveItems().get(this.selectedPart), this.key);
                }
            }
        }
    }

    public static class SyncHotkeyPacketHandler
    implements IMessageHandler<SyncHotkeyPacket, IMessage> {
        public IMessage onMessage(SyncHotkeyPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            DimensionManager.getWorld((int)player.field_70170_p.field_73011_w.getDimension()).func_152344_a((Runnable)new DoSync(message.selectedPart, message.key, (EntityPlayer)player));
            return null;
        }
    }
}

