/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VanillaWares {

    public static class SpiderEyeWare
    implements ICyberware {
        private static final ItemStack itemStackSpiderEye = new ItemStack(Items.field_151070_bp);

        public SpiderEyeWare() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @Override
        public ICyberware.EnumSlot getSlot(ItemStack stack) {
            return ICyberware.EnumSlot.EYES;
        }

        @Override
        public int installedStackSize(ItemStack stack) {
            return 1;
        }

        @Override
        public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
            return NonNullList.func_191196_a();
        }

        @Override
        public boolean isIncompatible(ItemStack stack, ItemStack other) {
            return CyberwareAPI.getCyberware(other).isEssential(other);
        }

        @Override
        public boolean isEssential(ItemStack stack) {
            return true;
        }

        @SubscribeEvent
        public void handleSpiderNightVision(CyberwareUpdateEvent event) {
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            if (entityLivingBase.field_70173_aa % 20 != 0) {
                return;
            }
            ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
            if (cyberwareUserData.isCyberwareInstalled(itemStackSpiderEye)) {
                entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, -53, true, false));
            } else {
                PotionEffect effect = entityLivingBase.func_70660_b(MobEffects.field_76439_r);
                if (effect != null && effect.func_76458_c() == -53) {
                    entityLivingBase.func_184589_d(MobEffects.field_76439_r);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onDrawScreenPost(RenderGameOverlayEvent.Pre event) {
            EntityPlayerSP entityPlayer;
            ICyberwareUserData cyberwareUserData;
            if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)(entityPlayer = Minecraft.func_71410_x().field_71439_g))) != null && cyberwareUserData.isCyberwareInstalled(itemStackSpiderEye)) {
                GlStateManager.func_179109_b((float)0.0f, (float)(event.getResolution().func_78328_b() / 5), (float)0.0f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
            EntityPlayerSP entityPlayer;
            ICyberwareUserData cyberwareUserData;
            if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)(entityPlayer = Minecraft.func_71410_x().field_71439_g))) != null && cyberwareUserData.isCyberwareInstalled(itemStackSpiderEye)) {
                GlStateManager.func_179109_b((float)0.0f, (float)(-event.getResolution().func_78328_b() / 5), (float)0.0f);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void handleSpiderVision(TickEvent.ClientTickEvent event) {
            ShaderGroup shaderGroup;
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
            if (cyberwareUserData != null && cyberwareUserData.isCyberwareInstalled(itemStackSpiderEye)) {
                if (Minecraft.func_71410_x().field_71460_t.func_147706_e() == null) {
                    Minecraft.func_71410_x().field_71460_t.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
                }
            } else if (entityPlayer != null && !entityPlayer.func_175149_v() && (shaderGroup = Minecraft.func_71410_x().field_71460_t.func_147706_e()) != null && shaderGroup.func_148022_b().equals("minecraft:shaders/post/spider.json")) {
                Minecraft.func_71410_x().field_71460_t.func_181022_b();
            }
        }

        @Override
        public List<String> getInfo(ItemStack stack) {
            String format;
            ArrayList<String> ret = new ArrayList<String>();
            String[] desc = this.getDesciption(stack);
            if (desc != null && desc.length > 0 && (format = desc[0]).length() > 0) {
                ret.addAll(Arrays.asList(desc));
            }
            return ret;
        }

        private String[] getDesciption(ItemStack stack) {
            return I18n.func_135052_a((String)"cyberware.tooltip.spider_eye", (Object[])new Object[0]).split("\\\\n");
        }

        @Override
        public int getCapacity(ItemStack wareStack) {
            return 0;
        }

        @Override
        public void onAdded(EntityLivingBase entityLivingBase, ItemStack stack) {
        }

        @Override
        public void onRemoved(EntityLivingBase entityLivingBase, ItemStack stack) {
        }

        @Override
        public int getEssenceCost(ItemStack stack) {
            return 5;
        }

        @Override
        public ICyberware.Quality getQuality(ItemStack stack) {
            return null;
        }

        @Override
        public ItemStack setQuality(ItemStack stack, ICyberware.Quality quality) {
            return stack;
        }

        @Override
        public boolean canHoldQuality(ItemStack stack, ICyberware.Quality quality) {
            return false;
        }
    }
}

