/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLungsUpgrade
extends ItemCyberware {
    private static final int META_COMPRESSED_OXYGEN = 0;
    private static final int META_HYPEROXYGENATION_BOOST = 1;
    private Set<UUID> setIsOxygenPowered = new HashSet<UUID>();

    public ItemLungsUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
            if (cyberwareUserData == null) {
                return;
            }
            ItemStack itemStackCompressedOxygen = cyberwareUserData.getCyberware(this.getCachedStack(0));
            if (!itemStackCompressedOxygen.func_190926_b() && !entityPlayer.func_184812_l_()) {
                GlStateManager.func_179094_E();
                int air = this.getAir(itemStackCompressedOxygen);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
                ScaledResolution res = event.getResolution();
                GlStateManager.func_179147_l();
                int left = res.func_78326_a() / 2 + 91;
                int top = res.func_78328_b() - 49 - 8;
                float r = 1.0f;
                float b = 1.0f;
                float g = 1.0f;
                if (entityPlayer.func_70055_a(Material.field_151586_h)) {
                    while (air > 0) {
                        GlStateManager.func_179124_c((float)(r += 1.0f), (float)(g += 0.25f), (float)(b -= 0.25f));
                        int drawAir = Math.min(300, air);
                        int full = MathHelper.func_76143_f((double)((double)(drawAir - 2) * 10.0 / 300.0));
                        int partial = MathHelper.func_76143_f((double)((double)drawAir * 10.0 / 300.0)) - full;
                        for (int i = 0; i < full + partial; ++i) {
                            ClientUtils.drawTexturedModalRect(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                        }
                        air -= 300;
                        top -= 8;
                    }
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        ItemStack itemStackHyperoxygenationBoost;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackCompressedAir = cyberwareUserData.getCyberware(this.getCachedStack(0));
        if (!itemStackCompressedAir.func_190926_b()) {
            int air = this.getAir(itemStackCompressedAir);
            if (entityLivingBase.func_70086_ai() < 300 && air > 0) {
                int toAdd = Math.min(300 - entityLivingBase.func_70086_ai(), air);
                entityLivingBase.func_70050_g(entityLivingBase.func_70086_ai() + toAdd);
                CyberwareAPI.getCyberwareNBT(itemStackCompressedAir).func_74768_a("air", air - toAdd);
            } else if (entityLivingBase.func_70086_ai() == 300 && air < 900) {
                CyberwareAPI.getCyberwareNBT(itemStackCompressedAir).func_74768_a("air", air + 1);
            }
        }
        if (!(itemStackHyperoxygenationBoost = cyberwareUserData.getCyberware(this.getCachedStack(1))).func_190926_b() && (entityLivingBase.func_70051_ag() || entityLivingBase instanceof EntityMob) && !entityLivingBase.func_70090_H() && entityLivingBase.field_70122_E) {
            boolean isPowered;
            boolean wasPowered = this.setIsOxygenPowered.contains(entityLivingBase.func_110124_au());
            boolean bl = isPowered = entityLivingBase.field_70173_aa % 20 == 0 ? cyberwareUserData.usePower(itemStackHyperoxygenationBoost, this.getPowerConsumption(itemStackHyperoxygenationBoost)) : wasPowered;
            if (isPowered) {
                if (Math.abs(entityLivingBase.field_70702_br) + Math.abs(entityLivingBase.field_191988_bg) > 0.0f && Math.abs(entityLivingBase.field_70159_w) + Math.abs(entityLivingBase.field_70179_y) > 0.0) {
                    float boost = 0.21f * (float)itemStackHyperoxygenationBoost.func_190916_E();
                    entityLivingBase.func_191958_b(entityLivingBase.field_70702_br * boost, 0.0f, entityLivingBase.field_191988_bg * boost, 0.075f);
                }
                if (!wasPowered) {
                    this.setIsOxygenPowered.add(entityLivingBase.func_110124_au());
                }
            } else if (entityLivingBase.field_70173_aa % 20 == 0) {
                this.setIsOxygenPowered.remove(entityLivingBase.func_110124_au());
            }
        }
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 3 : 1;
    }

    private int getAir(ItemStack stack) {
        NBTTagCompound tagCompound = CyberwareAPI.getCyberwareNBT(stack);
        if (!tagCompound.func_74764_b("air")) {
            tagCompound.func_74768_a("air", 900);
        }
        return tagCompound.func_74762_e("air");
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 1 * stack.func_190916_E() : 0;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }
}

