/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.misc.NNLUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemFootUpgrade
extends ItemCyberware
implements IMenuItem {
    public static final int META_SPURS = 0;
    public static final int META_AQUA = 1;
    public static final int META_WHEELS = 2;
    private Set<UUID> setIsAquaPowered = new HashSet<UUID>();
    private Map<UUID, Integer> mapCountdownWheelsPowered = new HashMap<UUID, Integer>();
    private Map<UUID, Float> mapStepHeight = new HashMap<UUID, Float>();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemFootUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
        if (stack.func_77952_i() != 1) {
            return NonNullList.func_191196_a();
        }
        return NNLUtil.fromArray(new ItemStack[][]{{CyberwareContent.cyberlimbs.getCachedStack(2), CyberwareContent.cyberlimbs.getCachedStack(3)}});
    }

    @SubscribeEvent
    public void handleHorseMove(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase instanceof EntityHorse) {
            ItemStack itemStackSpurs = this.getCachedStack(0);
            EntityHorse entityHorse = (EntityHorse)entityLivingBase;
            for (Entity entityPassenger : entityHorse.func_184188_bt()) {
                ICyberwareUserData cyberwareUserData;
                if (!(entityPassenger instanceof EntityLivingBase) || (cyberwareUserData = CyberwareAPI.getCapabilityOrNull(entityPassenger)) == null || !cyberwareUserData.isCyberwareInstalled(itemStackSpurs)) continue;
                entityHorse.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1, 5, true, false));
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        boolean isPowered;
        boolean wasPowered;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        if (!entityLivingBase.field_70122_E && entityLivingBase.func_70090_H()) {
            ItemStack itemStackAqua = cyberwareUserData.getCyberware(this.getCachedStack(1));
            if (!itemStackAqua.func_190926_b()) {
                wasPowered = this.setIsAquaPowered.contains(entityLivingBase.func_110124_au());
                boolean bl = isPowered = entityLivingBase.field_70173_aa % 20 == 0 ? cyberwareUserData.usePower(itemStackAqua, this.getPowerConsumption(itemStackAqua)) : wasPowered;
                if (isPowered) {
                    if (Math.abs(entityLivingBase.field_70702_br) + Math.abs(entityLivingBase.field_191988_bg) > 0.0f && Math.abs(entityLivingBase.field_70159_w) + Math.abs(entityLivingBase.field_70179_y) > 0.0) {
                        int numLegs = 0;
                        if (cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(2))) {
                            ++numLegs;
                        }
                        if (cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(3))) {
                            ++numLegs;
                        }
                        float boost = (float)numLegs * 0.4f;
                        entityLivingBase.func_191958_b(entityLivingBase.field_70702_br * boost, 0.26f, entityLivingBase.field_191988_bg * boost, 0.075f);
                    }
                    if (!wasPowered) {
                        this.setIsAquaPowered.add(entityLivingBase.func_110124_au());
                    }
                } else if (entityLivingBase.field_70173_aa % 20 == 0) {
                    this.setIsAquaPowered.remove(entityLivingBase.func_110124_au());
                }
            }
        } else if (entityLivingBase.field_70173_aa % 20 == 0) {
            this.setIsAquaPowered.remove(entityLivingBase.func_110124_au());
        }
        ItemStack itemStackWheels = cyberwareUserData.getCyberware(this.getCachedStack(2));
        if (!itemStackWheels.func_190926_b()) {
            boolean bl = wasPowered = this.getCountdownWheelsPowered(entityLivingBase) > 0;
            boolean bl2 = EnableDisableHelper.isEnabled(itemStackWheels) && (entityLivingBase.field_70173_aa % 20 == 0 ? cyberwareUserData.usePower(itemStackWheels, this.getPowerConsumption(itemStackWheels)) : wasPowered) ? true : (isPowered = false);
            if (isPowered) {
                if (!this.mapStepHeight.containsKey(entityLivingBase.func_110124_au())) {
                    this.mapStepHeight.put(entityLivingBase.func_110124_au(), Float.valueOf(Math.max(entityLivingBase.field_70138_W, 0.6f)));
                }
                entityLivingBase.field_70138_W = 1.0f;
                this.mapCountdownWheelsPowered.put(entityLivingBase.func_110124_au(), 10);
            } else if (this.mapStepHeight.containsKey(entityLivingBase.func_110124_au()) && wasPowered) {
                entityLivingBase.field_70138_W = this.mapStepHeight.get(entityLivingBase.func_110124_au()).floatValue();
                this.mapCountdownWheelsPowered.put(entityLivingBase.func_110124_au(), this.getCountdownWheelsPowered(entityLivingBase) - 1);
            } else {
                this.mapCountdownWheelsPowered.put(entityLivingBase.func_110124_au(), 0);
            }
        } else if (this.mapStepHeight.containsKey(entityLivingBase.func_110124_au())) {
            entityLivingBase.field_70138_W = this.mapStepHeight.get(entityLivingBase.func_110124_au()).floatValue();
            int countdownWheelsPowered = this.getCountdownWheelsPowered(entityLivingBase) - 1;
            if (countdownWheelsPowered == 0) {
                this.mapStepHeight.remove(entityLivingBase.func_110124_au());
            }
            this.mapCountdownWheelsPowered.put(entityLivingBase.func_110124_au(), countdownWheelsPowered);
        }
    }

    private int getCountdownWheelsPowered(EntityLivingBase entityLivingBase) {
        return this.mapCountdownWheelsPowered.computeIfAbsent(entityLivingBase.func_110124_au(), k -> 10);
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 1 : (stack.func_77952_i() == 2 ? 2 : 0);
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 2;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }
}

