/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUserDataImpl;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntityBeacon;
import flaxbeard.cyberware.common.entity.EntityCyberZombie;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandler;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.CyberwareSyncPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CyberwareDataHandler {
    public static final CyberwareDataHandler INSTANCE = new CyberwareDataHandler();
    public static final String KEEP_WARE_GAMERULE = "cyberware_keepCyberware";
    public static final String DROP_WARE_GAMERULE = "cyberware_dropCyberware";

    @SubscribeEvent
    public void onEntityConstructed(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
            entityLivingBase.func_110140_aT().func_111150_b(CyberwareAPI.TOLERANCE_ATTR);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        GameRules rules = event.getWorld().func_82736_K();
        if (!rules.func_82765_e(KEEP_WARE_GAMERULE)) {
            rules.func_180262_a(KEEP_WARE_GAMERULE, Boolean.toString(CyberwareConfig.DEFAULT_KEEP), GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!rules.func_82765_e(DROP_WARE_GAMERULE)) {
            rules.func_180262_a(DROP_WARE_GAMERULE, Boolean.toString(CyberwareConfig.DEFAULT_DROP), GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public void attachCyberwareData(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CyberwareUserDataImpl.Provider.NAME, (ICapabilityProvider)new CyberwareUserDataImpl.Provider());
        }
    }

    @SubscribeEvent
    public void playerDeathEvent(PlayerEvent.Clone event) {
        EntityPlayer entityPlayerLiving = event.getEntityPlayer();
        EntityPlayer entityPlayerDead = event.getOriginal();
        if (event.isWasDeath()) {
            if (entityPlayerLiving.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE)) {
                ICyberwareUserData cyberwareUserDataDead = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerDead);
                ICyberwareUserData cyberwareUserDataLiving = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerLiving);
                if (cyberwareUserDataDead != null && cyberwareUserDataLiving != null) {
                    cyberwareUserDataLiving.deserializeNBT(cyberwareUserDataDead.serializeNBT());
                }
            }
        } else {
            ICyberwareUserData cyberwareUserDataDead = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerDead);
            ICyberwareUserData cyberwareUserDataLiving = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerLiving);
            if (cyberwareUserDataDead != null && cyberwareUserDataLiving != null) {
                cyberwareUserDataLiving.deserializeNBT(cyberwareUserDataDead.serializeNBT());
            }
        }
    }

    @SubscribeEvent
    public void handleCyberzombieDrops(LivingDropsEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase instanceof EntityPlayer && !entityLivingBase.field_70170_p.field_72995_K) {
            ICyberwareUserData cyberwareUserData;
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            if ((entityPlayer.field_70170_p.func_72912_H().func_82574_x().func_82766_b(DROP_WARE_GAMERULE) && !entityPlayer.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE) || entityPlayer.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE) && this.shouldDropWare(event.getSource())) && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer)) != null) {
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    NonNullList<ItemStack> nnlInstalled = cyberwareUserData.getInstalledCyberware(slot);
                    NonNullList nnlDefaults = NonNullList.func_191196_a();
                    for (ItemStack itemStackDefault : CyberwareConfig.getStartingItems(ICyberware.EnumSlot.values()[slot.ordinal()])) {
                        nnlDefaults.add((Object)itemStackDefault.func_77946_l());
                    }
                    for (ItemStack itemStackInstalled : nnlInstalled) {
                        if (itemStackInstalled.func_190926_b()) continue;
                        ItemStack itemStackToDrop = itemStackInstalled.func_77946_l();
                        boolean found = false;
                        for (ItemStack itemStackDefault : nnlDefaults) {
                            if (!CyberwareAPI.areCyberwareStacksEqual(itemStackDefault, itemStackToDrop)) continue;
                            if (itemStackToDrop.func_190916_E() > itemStackDefault.func_190916_E()) {
                                itemStackToDrop.func_190918_g(itemStackDefault.func_190916_E());
                                continue;
                            }
                            found = true;
                        }
                        if (found || !(entityPlayer.field_70170_p.field_73012_v.nextFloat() < CyberwareConfig.DROP_CHANCE / 100.0f)) continue;
                        EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, itemStackToDrop);
                        event.getDrops().add(entityItem);
                    }
                }
                cyberwareUserData.resetWare((EntityLivingBase)entityPlayer);
            }
        }
    }

    private boolean shouldDropWare(DamageSource source) {
        if (source == EssentialsMissingHandler.noessence) {
            return true;
        }
        if (source == EssentialsMissingHandler.heartless) {
            return true;
        }
        if (source == EssentialsMissingHandler.brainless) {
            return true;
        }
        if (source == EssentialsMissingHandler.nomuscles) {
            return true;
        }
        return source == EssentialsMissingHandler.spineless;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleCZSpawn(LivingSpawnEvent.SpecialSpawn event) {
        int tier;
        ResourceLocation resourceLocation;
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        Object entityLiving = (EntityLiving)event.getEntityLiving();
        if (!(!(entityLiving instanceof EntityPigZombie) && entityLiving instanceof EntityZombie || (resourceLocation = EntityList.func_191301_a((Entity)entityLiving)) != null && resourceLocation.func_110623_a().contains("ombie"))) {
            return;
        }
        if (CyberwareConfig.MOBS_ENABLE_CYBER_ZOMBIES && !(entityLiving instanceof EntityCyberZombie) && (!CyberwareConfig.MOBS_APPLY_DIMENSION_TO_BEACON || this.isValidDimension(event.getWorld())) && (tier = TileEntityBeacon.isInRange(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v)) > 0) {
            float chance;
            float f = tier == 2 ? 10.0f : (chance = tier == 1 ? 5.0f : 20.0f);
            if (event.getWorld().field_73012_v.nextFloat() < chance / 100.0f) {
                EntityCyberZombie entityCyberZombie = new EntityCyberZombie(event.getWorld());
                if (event.getWorld().field_73012_v.nextFloat() < 0.5f) {
                    entityCyberZombie.setBrute();
                }
                entityCyberZombie.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
                entityCyberZombie.func_180482_a(event.getWorld().func_175649_E(entityCyberZombie.func_180425_c()), null);
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    if (!entityCyberZombie.func_184582_a(slot).func_190926_b()) continue;
                    entityCyberZombie.func_184201_a(slot, entityLiving.func_184582_a(slot));
                }
                event.getWorld().func_72838_d((Entity)entityCyberZombie);
                entityLiving.field_70725_aQ = 19;
                entityLiving.func_70606_j(0.0f);
                entityLiving = entityCyberZombie;
            }
        }
        if (CyberwareConfig.ENABLE_CLOTHES && CyberwareConfig.MOBS_ADD_CLOTHES) {
            if (entityLiving.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && entityLiving.field_70170_p.field_73012_v.nextFloat() < 0.04f) {
                if (entityLiving.field_70170_p.field_73012_v.nextBoolean()) {
                    entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CyberwareContent.shades));
                } else {
                    entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CyberwareContent.shades2));
                }
                entityLiving.func_184642_a(EntityEquipmentSlot.HEAD, CyberwareConfig.MOBS_CLOTH_DROP_RARITY / 100.0f);
            }
            float chestRand = entityLiving.field_70170_p.field_73012_v.nextFloat();
            if (entityLiving.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && chestRand < 0.04f) {
                ItemStack stack = new ItemStack((Item)CyberwareContent.trenchCoat);
                int rand = entityLiving.field_70170_p.field_73012_v.nextInt(3);
                if (rand == 0) {
                    CyberwareContent.trenchCoat.func_82813_b(stack, 6701096);
                } else if (rand == 1) {
                    CyberwareContent.trenchCoat.func_82813_b(stack, 0xEAEAEA);
                }
                entityLiving.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                entityLiving.func_184642_a(EntityEquipmentSlot.CHEST, CyberwareConfig.MOBS_CLOTH_DROP_RARITY / 100.0f);
            } else if (entityLiving.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && chestRand - 0.04f < 0.04f) {
                ItemStack stack = new ItemStack(CyberwareContent.jacket);
                entityLiving.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                entityLiving.func_184642_a(EntityEquipmentSlot.CHEST, CyberwareConfig.MOBS_CLOTH_DROP_RARITY / 100.0f);
            }
        }
    }

    public static void addRandomCyberware(EntityCyberZombie cyberZombie, boolean brute) {
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)cyberZombie);
        if (cyberwareUserData == null) {
            return;
        }
        NonNullList wares = NonNullList.func_191196_a();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NonNullList<ItemStack> toAdd = cyberwareUserData.getInstalledCyberware(slot);
            toAdd.removeAll(Collections.singleton(ItemStack.field_190927_a));
            wares.add(toAdd);
        }
        ItemStack battery = new ItemStack((Item)CyberwareContent.creativeBattery);
        ((NonNullList)wares.get(CyberwareContent.creativeBattery.getSlot(battery).ordinal())).add((Object)battery);
        int numberOfItemsToInstall = ((CyberwareContent.NumItems)WeightedRandom.func_76271_a((Random)cyberZombie.field_70170_p.field_73012_v, CyberwareContent.numItems)).num;
        if (brute) {
            numberOfItemsToInstall += 2;
        }
        ArrayList<ItemStack> installed = new ArrayList<ItemStack>();
        ArrayList<CyberwareContent.ZombieItem> items = new ArrayList<CyberwareContent.ZombieItem>(CyberwareContent.zombieItems);
        for (int indexItem = 0; indexItem < numberOfItemsToInstall; ++indexItem) {
            ItemStack randomItem;
            ICyberware randomWare;
            int tries = 0;
            do {
                randomItem = ((CyberwareContent.ZombieItem)WeightedRandom.func_76271_a((Random)cyberZombie.field_70170_p.field_73012_v, items)).stack.func_77946_l();
                randomWare = CyberwareAPI.getCyberware(randomItem);
                randomItem.func_190920_e(randomWare.installedStackSize(randomItem));
            } while (CyberwareDataHandler.contains((NonNullList<ItemStack>)((NonNullList)wares.get(randomWare.getSlot(randomItem).ordinal())), randomItem) && ++tries < 10);
            if (tries >= 10) continue;
            NonNullList<NonNullList<ItemStack>> required = randomWare.required(randomItem);
            for (NonNullList requiredCategory : required) {
                boolean found = false;
                for (ItemStack option : requiredCategory) {
                    ICyberware optionWare = CyberwareAPI.getCyberware(option);
                    option.func_190920_e(optionWare.installedStackSize(option));
                    if (!CyberwareDataHandler.contains((NonNullList<ItemStack>)((NonNullList)wares.get(optionWare.getSlot(option).ordinal())), option)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ItemStack req = ((ItemStack)requiredCategory.get(cyberZombie.field_70170_p.field_73012_v.nextInt(requiredCategory.size()))).func_77946_l();
                ICyberware reqWare = CyberwareAPI.getCyberware(req);
                req.func_190920_e(reqWare.installedStackSize(req));
                ((NonNullList)wares.get(reqWare.getSlot(req).ordinal())).add((Object)req);
                installed.add(req);
                ++indexItem;
            }
            ((NonNullList)wares.get(randomWare.getSlot(randomItem).ordinal())).add((Object)randomItem);
            installed.add(randomItem);
        }
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            cyberwareUserData.setInstalledCyberware((EntityLivingBase)cyberZombie, slot, (NonNullList<ItemStack>)((NonNullList)wares.get(slot.ordinal())));
        }
        cyberwareUserData.updateCapacity();
        cyberZombie.func_70606_j(cyberZombie.func_110138_aP());
        cyberZombie.hasRandomWare = true;
        CyberwareAPI.updateData((Entity)cyberZombie);
    }

    private static boolean contains(NonNullList<ItemStack> nnlHaystack, ItemStack needle) {
        for (ItemStack check : nnlHaystack) {
            if (check.func_190926_b() || needle.func_190926_b() || check.func_77973_b() != needle.func_77973_b() || check.func_77952_i() != needle.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPotentialSpawns(@Nonnull WorldEvent.PotentialSpawns event) {
        if (event.getType() != EnumCreatureType.MONSTER) {
            return;
        }
        if (!CyberwareConfig.MOBS_APPLY_DIMENSION_TO_SPAWNING) {
            return;
        }
        if (this.isValidDimension(event.getWorld())) {
            return;
        }
        ArrayList<Biome.SpawnListEntry> spawnListEntriesToRemove = new ArrayList<Biome.SpawnListEntry>(4);
        for (Biome.SpawnListEntry spawnListEntry : event.getList()) {
            if (!spawnListEntry.field_76300_b.equals(EntityCyberZombie.class)) continue;
            spawnListEntriesToRemove.add(spawnListEntry);
        }
        event.getList().removeAll(spawnListEntriesToRemove);
    }

    public boolean isValidDimension(@Nonnull World world) {
        boolean isListed = CyberwareConfig.MOBS_DIMENSION_IDS.contains(world.field_73011_w.getDimension());
        return CyberwareConfig.MOBS_IS_DIMENSION_BLACKLIST && !isListed || !CyberwareConfig.MOBS_IS_DIMENSION_BLACKLIST && isListed;
    }

    @SubscribeEvent
    public void syncCyberwareData(EntityJoinWorldEvent event) {
        ICyberwareUserData cyberwareUserData;
        Entity entity;
        if (!event.getWorld().field_72995_K && (entity = event.getEntity()) instanceof EntityPlayer && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull(entity)) != null) {
            NBTTagCompound tagCompound = cyberwareUserData.serializeNBT();
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new CyberwareSyncPacket(tagCompound, entity.func_145782_y()), (EntityPlayerMP)entity);
        }
    }

    @SubscribeEvent
    public void startTrackingEvent(PlayerEvent.StartTracking event) {
        ICyberwareUserData cyberwareUserData;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        Entity entityTarget = event.getTarget();
        if (!entityTarget.field_70170_p.field_72995_K && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull(entityTarget)) != null) {
            NBTTagCompound tagCompound = cyberwareUserData.serializeNBT();
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new CyberwareSyncPacket(tagCompound, entityTarget.func_145782_y()), (EntityPlayerMP)entityPlayer);
        }
    }
}

