/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareSurgeryEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.BlockSurgeryChamber;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandler;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySurgery
extends TileEntity
implements ITickable {
    public ItemStackHandler slotsPlayer = new ItemStackHandler(120);
    public ItemStackHandler slots = new ItemStackHandler(120);
    public boolean[] discardSlots = new boolean[120];
    public boolean[] isEssentialMissing = new boolean[ICyberware.EnumSlot.values().length * 2];
    public int essence = 0;
    public int maxEssence = 0;
    public int wrongSlot = -1;
    public int ticksWrong = 0;
    public int lastEntity = -1;
    public int cooldownTicks = 0;
    public boolean missingPower = false;
    public boolean inProgress = false;
    public EntityLivingBase targetEntity = null;
    public int progressTicks = 0;
    public static boolean workingOnPlayer = false;
    public static int playerProgressTicks = 0;

    public boolean isUsableByPlayer(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void updatePlayerSlots(EntityLivingBase entityLivingBase, ICyberwareUserData cyberwareUserData) {
        this.func_70296_d();
        if (cyberwareUserData != null) {
            int indexSlot;
            if (entityLivingBase.func_145782_y() != this.lastEntity) {
                for (int indexEssential = 0; indexEssential < this.discardSlots.length; ++indexEssential) {
                    this.discardSlots[indexEssential] = false;
                }
                this.lastEntity = entityLivingBase.func_145782_y();
            }
            this.maxEssence = cyberwareUserData.getMaxTolerance(entityLivingBase);
            for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                NonNullList<ItemStack> cyberwares = cyberwareUserData.getInstalledCyberware(slot);
                for (indexSlot = 0; indexSlot < 10; ++indexSlot) {
                    ItemStack toPut = ((ItemStack)cyberwares.get(indexSlot)).func_77946_l();
                    if (!ItemStack.func_77989_b((ItemStack)toPut, (ItemStack)this.slotsPlayer.getStackInSlot(slot.ordinal() * 10 + indexSlot))) {
                        this.discardSlots[slot.ordinal() * 10 + indexSlot] = this.doesItemConflict(toPut, slot, indexSlot);
                    }
                    this.slotsPlayer.setStackInSlot(slot.ordinal() * 10 + indexSlot, toPut);
                }
                this.updateEssential(slot);
            }
            boolean needToCheck = true;
            while (needToCheck) {
                needToCheck = false;
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    for (indexSlot = 0; indexSlot < 10; ++indexSlot) {
                        int index = slot.ordinal() * 10 + indexSlot;
                        ItemStack stack = this.slots.getStackInSlot(index);
                        if (stack.func_190926_b() || this.areRequirementsFulfilled(stack, slot, indexSlot)) continue;
                        this.addItemStack(entityLivingBase, stack);
                        this.slots.setStackInSlot(index, ItemStack.field_190927_a);
                        needToCheck = true;
                    }
                }
            }
            this.updateEssence();
        } else {
            this.slotsPlayer = new ItemStackHandler(120);
            this.maxEssence = CyberwareConfig.ESSENCE;
            for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                this.updateEssential(slot);
            }
        }
        this.wrongSlot = -1;
    }

    public boolean doesItemConflict(@Nonnull ItemStack stack, ICyberware.EnumSlot slot, int indexSlotToCheck) {
        int row = slot.ordinal();
        if (!stack.func_190926_b()) {
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                ItemStack otherStack;
                if (indexSlot == indexSlotToCheck) continue;
                int index = row * 10 + indexSlot;
                ItemStack slotStack = this.slots.getStackInSlot(index);
                ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                if (!otherStack.func_190926_b() && otherStack.func_77973_b() == stack.func_77973_b() && otherStack.func_77952_i() == stack.func_77952_i()) {
                    this.setWrongSlot(index);
                    return true;
                }
                if (!otherStack.func_190926_b() && CyberwareAPI.getCyberware(otherStack).isIncompatible(otherStack, stack)) {
                    this.setWrongSlot(index);
                    return true;
                }
                if (otherStack.func_190926_b() || !CyberwareAPI.getCyberware(stack).isIncompatible(stack, otherStack)) continue;
                this.setWrongSlot(index);
                return true;
            }
        }
        return false;
    }

    public void setWrongSlot(int index) {
        this.wrongSlot = index;
        Cyberware.proxy.wrong(this);
    }

    public void disableDependants(ItemStack stack, ICyberware.EnumSlot slot, int indexSlotToCheck) {
        int row = slot.ordinal();
        if (!stack.func_190926_b()) {
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                int index;
                ItemStack playerStack;
                if (indexSlot == indexSlotToCheck || this.areRequirementsFulfilled(playerStack = this.slotsPlayer.getStackInSlot(index = row * 10 + indexSlot), slot, indexSlotToCheck)) continue;
                this.discardSlots[index] = true;
            }
        }
    }

    public void enableDependsOn(ItemStack stack, ICyberware.EnumSlot slot, int indexSlotToCheck) {
        if (!stack.func_190926_b()) {
            ICyberware ware = CyberwareAPI.getCyberware(stack);
            for (NonNullList neededItem : ware.required(stack)) {
                boolean found = false;
                block1: for (ItemStack needed : neededItem) {
                    for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                        for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                            int index;
                            ItemStack playerStack;
                            if (indexSlot == indexSlotToCheck || (playerStack = this.slotsPlayer.getStackInSlot(index = row * 10 + indexSlot)).func_190926_b() || playerStack.func_77973_b() != needed.func_77973_b() || playerStack.func_77952_i() != needed.func_77952_i()) continue;
                            found = true;
                            this.discardSlots[index] = false;
                            break block1;
                        }
                    }
                }
                if (found) continue;
                Cyberware.logger.error(String.format("Can't find required %s for %s in %s:%d", new Object[]{neededItem, stack, slot, indexSlotToCheck}));
            }
        }
    }

    public boolean canDisableItem(ItemStack stack, ICyberware.EnumSlot slot, int indexSlotToCheck) {
        if (!stack.func_190926_b()) {
            for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                    ItemStack otherStack;
                    if (indexSlot == indexSlotToCheck) continue;
                    int index = row * 10 + indexSlot;
                    ItemStack slotStack = this.slots.getStackInSlot(index);
                    ItemStack playerStack = ItemStack.field_190927_a;
                    ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                    if (this.areRequirementsFulfilled(otherStack, slot, indexSlotToCheck)) continue;
                    this.setWrongSlot(index);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean areRequirementsFulfilled(ItemStack stack, ICyberware.EnumSlot slot, int indexSlotToCheck) {
        if (!stack.func_190926_b()) {
            ICyberware ware = CyberwareAPI.getCyberware(stack);
            for (NonNullList neededItem : ware.required(stack)) {
                boolean found = false;
                block1: for (ItemStack needed : neededItem) {
                    for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                        for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                            ItemStack otherStack;
                            if (indexSlot == indexSlotToCheck) continue;
                            int index = row * 10 + indexSlot;
                            ItemStack slotStack = this.slots.getStackInSlot(index);
                            ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                            ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                            if (otherStack.func_190926_b() || otherStack.func_77973_b() != needed.func_77973_b() || otherStack.func_77952_i() != needed.func_77952_i()) continue;
                            found = true;
                            break block1;
                        }
                    }
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.slots.deserializeNBT(tagCompound.func_74775_l("inv"));
        this.slotsPlayer.deserializeNBT(tagCompound.func_74775_l("inv2"));
        NBTTagList list = (NBTTagList)tagCompound.func_74781_a("discard");
        for (int indexEssential = 0; indexEssential < list.func_74745_c(); ++indexEssential) {
            this.discardSlots[indexEssential] = ((NBTTagByte)list.func_179238_g(indexEssential)).func_150290_f() > 0;
        }
        this.essence = tagCompound.func_74762_e("essence");
        this.maxEssence = tagCompound.func_74762_e("maxEssence");
        this.lastEntity = tagCompound.func_74762_e("lastEntity");
        this.missingPower = tagCompound.func_74767_n("missingPower");
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("essence", this.essence);
        tagCompound.func_74768_a("maxEssence", this.maxEssence);
        tagCompound.func_74768_a("lastEntity", this.lastEntity);
        tagCompound.func_74757_a("missingPower", this.missingPower);
        tagCompound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        tagCompound.func_74782_a("inv2", (NBTBase)this.slotsPlayer.serializeNBT());
        NBTTagList list = new NBTTagList();
        for (boolean discardSlot : this.discardSlots) {
            list.func_74742_a((NBTBase)new NBTTagByte((byte)(discardSlot ? 1 : 0)));
        }
        tagCompound.func_74782_a("discard", (NBTBase)list);
        return tagCompound;
    }

    public void updateEssential(ICyberware.EnumSlot slot) {
        if (slot.hasEssential()) {
            byte answer = this.isEssential(slot);
            boolean foundFirst = (answer & 1) > 0;
            boolean foundSecond = (answer & 2) > 0;
            this.isEssentialMissing[slot.ordinal() * 2] = !foundFirst;
            this.isEssentialMissing[slot.ordinal() * 2 + 1] = !foundSecond;
        } else {
            this.isEssentialMissing[slot.ordinal() * 2] = false;
            this.isEssentialMissing[slot.ordinal() * 2 + 1] = false;
        }
    }

    private byte isEssential(ICyberware.EnumSlot slot) {
        byte r = 0;
        for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
            ICyberware ware;
            ItemStack stack;
            int index = slot.ordinal() * 10 + indexSlot;
            ItemStack slotStack = this.slots.getStackInSlot(index);
            ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
            ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (stack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
            if (stack.func_190926_b() || !(ware = CyberwareAPI.getCyberware(stack)).isEssential(stack)) continue;
            if (slot.isSided() && ware instanceof ICyberware.ISidedLimb) {
                if (((ICyberware.ISidedLimb)((Object)ware)).getSide(stack) == ICyberware.ISidedLimb.EnumSide.LEFT && (r & 1) == 0) {
                    r = (byte)(r + 1);
                    continue;
                }
                if ((r & 2) != 0) continue;
                r = (byte)(r + 2);
                continue;
            }
            return 3;
        }
        return r;
    }

    public void func_73660_a() {
        if (this.inProgress && this.progressTicks < 80) {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)this.targetEntity);
            if (this.targetEntity != null && !this.targetEntity.field_70128_L && cyberwareUserData != null) {
                BlockPos pos = this.func_174877_v();
                if (this.progressTicks > 20 && this.progressTicks < 60) {
                    this.targetEntity.field_70165_t = (float)pos.func_177958_n() + 0.5f;
                    this.targetEntity.field_70161_v = (float)pos.func_177952_p() + 0.5f;
                }
                if (this.progressTicks >= 20 && this.progressTicks <= 60 && this.progressTicks % 5 == 0) {
                    this.targetEntity.func_70097_a(EssentialsMissingHandler.surgery, 2.0f);
                }
                if (this.progressTicks == 60) {
                    this.processUpdate(cyberwareUserData);
                }
                ++this.progressTicks;
                if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                    workingOnPlayer = true;
                    playerProgressTicks = this.progressTicks;
                }
            } else {
                this.inProgress = false;
                this.progressTicks = 0;
                if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                    workingOnPlayer = false;
                }
                this.targetEntity = null;
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
                if (state.func_177230_c() instanceof BlockSurgeryChamber) {
                    ((BlockSurgeryChamber)state.func_177230_c()).toggleDoor(true, state, this.func_174877_v().func_177977_b(), this.field_145850_b);
                }
            }
        } else if (this.inProgress) {
            if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                workingOnPlayer = false;
            }
            this.inProgress = false;
            this.progressTicks = 0;
            this.targetEntity = null;
            this.cooldownTicks = 60;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
            if (state.func_177230_c() instanceof BlockSurgeryChamber) {
                ((BlockSurgeryChamber)state.func_177230_c()).toggleDoor(true, state, this.func_174877_v().func_177977_b(), this.field_145850_b);
            }
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void processUpdate(ICyberwareUserData cyberwareUserData) {
        this.updatePlayerSlots(this.targetEntity, cyberwareUserData);
        for (int indexCyberSlot = 0; indexCyberSlot < ICyberware.EnumSlot.values().length; ++indexCyberSlot) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[indexCyberSlot];
            NonNullList nnlToInstall = NonNullList.func_191196_a();
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                nnlToInstall.add((Object)ItemStack.field_190927_a);
            }
            int indexToInstall = 0;
            for (int indexCyberware = indexCyberSlot * 10; indexCyberware < (indexCyberSlot + 1) * 10; ++indexCyberware) {
                ItemStack itemStackSurgery = this.slots.getStackInSlot(indexCyberware);
                ItemStack itemStackPlayer = this.slotsPlayer.getStackInSlot(indexCyberware).func_77946_l();
                if (!itemStackSurgery.func_190926_b()) {
                    ItemStack itemStackToSet = itemStackSurgery.func_77946_l();
                    if (CyberwareAPI.areCyberwareStacksEqual(itemStackToSet, itemStackPlayer)) {
                        int maxSize = CyberwareAPI.getCyberware(itemStackToSet).installedStackSize(itemStackToSet);
                        if (itemStackToSet.func_190916_E() < maxSize) {
                            int numToShift = Math.min(maxSize - itemStackToSet.func_190916_E(), itemStackPlayer.func_190916_E());
                            itemStackPlayer.func_190918_g(numToShift);
                            itemStackToSet.func_190917_f(numToShift);
                        }
                    }
                    if (!itemStackPlayer.func_190926_b()) {
                        itemStackPlayer = CyberwareAPI.sanitize(itemStackPlayer);
                        this.addItemStack(this.targetEntity, itemStackPlayer);
                    }
                    nnlToInstall.set(indexToInstall, (Object)itemStackToSet);
                    ++indexToInstall;
                    continue;
                }
                if (itemStackPlayer.func_190926_b()) continue;
                if (this.discardSlots[indexCyberware]) {
                    itemStackPlayer = CyberwareAPI.sanitize(itemStackPlayer);
                    this.addItemStack(this.targetEntity, itemStackPlayer);
                    continue;
                }
                nnlToInstall.set(indexToInstall, (Object)this.slotsPlayer.getStackInSlot(indexCyberware).func_77946_l());
                ++indexToInstall;
            }
            if (!this.field_145850_b.field_72995_K) {
                cyberwareUserData.setInstalledCyberware(this.targetEntity, slot, (NonNullList<ItemStack>)nnlToInstall);
            }
            cyberwareUserData.setHasEssential(slot, !this.isEssentialMissing[indexCyberSlot * 2], !this.isEssentialMissing[indexCyberSlot * 2 + 1]);
        }
        cyberwareUserData.setTolerance(this.targetEntity, this.essence);
        cyberwareUserData.updateCapacity();
        cyberwareUserData.setImmune();
        if (!this.field_145850_b.field_72995_K) {
            CyberwareAPI.updateData((Entity)this.targetEntity);
        }
        this.slots = new ItemStackHandler(120);
        CyberwareSurgeryEvent.Post postSurgeryEvent = new CyberwareSurgeryEvent.Post(this.targetEntity);
        MinecraftForge.EVENT_BUS.post((Event)postSurgeryEvent);
    }

    private void addItemStack(EntityLivingBase entityLivingBase, ItemStack stack) {
        boolean flag = true;
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            boolean bl = flag = !entityPlayer.field_71071_by.func_70441_a(stack);
        }
        if (flag && !this.field_145850_b.field_72995_K) {
            EntityItem item = new EntityItem(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() - 2.0f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public boolean canOpen() {
        return !this.inProgress && this.cooldownTicks <= 0;
    }

    public void notifyChange() {
        BlockPos p;
        List entityLivingBases;
        boolean opened = (Boolean)this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177229_b((IProperty)BlockSurgeryChamber.OPEN);
        if (!opened && (entityLivingBases = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(p = this.func_174877_v()).func_177958_n(), (double)((float)p.func_177956_o() - 2.0f), (double)p.func_177952_p(), (double)((float)p.func_177958_n() + 1.0f), (double)p.func_177956_o(), (double)((float)p.func_177952_p() + 1.0f)))).size() == 1) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entityLivingBases.get(0);
            CyberwareSurgeryEvent.Pre preSurgeryEvent = new CyberwareSurgeryEvent.Pre(entityLivingBase, this.slotsPlayer, this.slots);
            if (!MinecraftForge.EVENT_BUS.post((Event)preSurgeryEvent)) {
                this.inProgress = true;
                this.progressTicks = 0;
                this.targetEntity = entityLivingBase;
            } else {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
                if (state.func_177230_c() instanceof BlockSurgeryChamber) {
                    ((BlockSurgeryChamber)state.func_177230_c()).toggleDoor(true, state, this.func_174877_v().func_177977_b(), this.field_145850_b);
                }
            }
        }
    }

    public void updateEssence() {
        this.essence = this.maxEssence;
        boolean hasConsume = false;
        boolean hasProduce = false;
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                ItemStack stack;
                int index = slot.ordinal() * 10 + indexSlot;
                ItemStack slotStack = this.slots.getStackInSlot(index);
                ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (stack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                if (stack.func_190926_b()) continue;
                ItemStack ret = stack.func_77946_l();
                if (!slotStack.func_190926_b() && !ret.func_190926_b() && !playerStack.func_190926_b() && CyberwareAPI.areCyberwareStacksEqual(playerStack, ret)) {
                    int maxSize = CyberwareAPI.getCyberware(ret).installedStackSize(ret);
                    if (ret.func_190916_E() < maxSize) {
                        int numToShift = Math.min(maxSize - ret.func_190916_E(), playerStack.func_190916_E());
                        ret.func_190917_f(numToShift);
                    }
                }
                ICyberware ware = CyberwareAPI.getCyberware(ret);
                this.essence -= ware.getEssenceCost(ret);
                if (ware instanceof ItemCyberware && ((ItemCyberware)ware).getPowerConsumption(ret) > 0) {
                    hasConsume = true;
                }
                if (!(ware instanceof ItemCyberware) || ((ItemCyberware)ware).getPowerProduction(ret) <= 0 && ware != CyberwareContent.creativeBattery) continue;
                hasProduce = true;
            }
        }
        this.missingPower = hasConsume && !hasProduce;
    }
}

