/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.handler.HudHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PowerDisplay
extends HudElementBase {
    private static final float[] colorLowPowerFloats = new float[]{1.0f, 0.0f, 0.125f};
    private static final int colorLowPowerHex = 0xFF0020;
    private static float cache_percentFull = 0.0f;
    private static int cache_power_capacity = 0;
    private static int cache_power_stored = 0;
    private static int cache_power_production = 0;
    private static int cache_power_consumption = 0;
    private static float[] cache_hudColor = colorLowPowerFloats;
    private static int cache_hudColorHex = 65535;

    public PowerDisplay() {
        super("cyberware:power");
        this.setDefaultX(5);
        this.setDefaultY(5);
        this.setHeight(25);
        this.setWidth(101);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer entityPlayer, ScaledResolution resolution, boolean isHUDjackAvailable, boolean isConfigOpen, float partialTicks) {
        boolean isCriticalPower;
        boolean isRightAnchored;
        if (this.isHidden() || !isHUDjackAvailable) {
            return;
        }
        boolean bl = isRightAnchored = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
        if (entityPlayer.field_70173_aa % 20 == 0) {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
            if (cyberwareUserData == null) {
                return;
            }
            cache_percentFull = cyberwareUserData.getPercentFull();
            cache_power_capacity = cyberwareUserData.getCapacity();
            cache_power_stored = cyberwareUserData.getStoredPower();
            cache_power_production = cyberwareUserData.getProduction();
            cache_power_consumption = cyberwareUserData.getConsumption();
            cache_hudColor = cyberwareUserData.getHudColor();
            cache_hudColorHex = cyberwareUserData.getHudColorHex();
        }
        if (cache_power_capacity == 0) {
            return;
        }
        boolean isLowPower = cache_percentFull <= 0.2f;
        boolean bl2 = isCriticalPower = cache_percentFull <= 0.05f;
        if (isCriticalPower && entityPlayer.field_70173_aa % 4 == 0) {
            return;
        }
        float[] colorFloats = isLowPower ? colorLowPowerFloats : cache_hudColor;
        int colorHex = isLowPower ? 0xFF0020 : cache_hudColorHex;
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int uOffset = isLowPower ? 39 : 0;
        int xOffset = isRightAnchored ? x + this.getWidth() - 13 : x;
        int yBatterySize = Math.round(21.0f * cache_percentFull);
        GlStateManager.func_179124_c((float)colorFloats[0], (float)colorFloats[1], (float)colorFloats[2]);
        ClientUtils.drawTexturedModalRect(xOffset, y, uOffset, 0, 13, 2 + (21 - yBatterySize));
        ClientUtils.drawTexturedModalRect(xOffset, y + 2 + (21 - yBatterySize), 13 + uOffset, 2 + (21 - yBatterySize), 13, yBatterySize + 2);
        ClientUtils.drawTexturedModalRect(xOffset, y + 2 + (21 - yBatterySize), 26 + uOffset, 2 + (21 - yBatterySize), 13, yBatterySize + 2);
        String textPowerStorage = cache_power_stored + " / " + cache_power_capacity;
        int xPowerStorage = isRightAnchored ? x + this.getWidth() - 15 - fontRenderer.func_78256_a(textPowerStorage) : x + 15;
        fontRenderer.func_175063_a(textPowerStorage, (float)xPowerStorage, (float)(y + 4), colorHex);
        String textPowerProgression = "-" + cache_power_consumption + " / +" + cache_power_production;
        int xPowerProgression = isRightAnchored ? x + this.getWidth() - 15 - fontRenderer.func_78256_a(textPowerProgression) : x + 15;
        fontRenderer.func_175063_a(textPowerProgression, (float)xPowerProgression, (float)(y + 14), colorHex);
        GlStateManager.func_179121_F();
    }
}

