/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.assetmover;

import com.cleanroommc.assetmover.AssetMoverAPI;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public enum AssetMoverHelper {

    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36 Edg/107.0.1418.42";
    private static final String VERSIONS_MANIFEST = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final String RESOURCES_URL = "https://resources.download.minecraft.net/";
    private static ExecutorService EXECUTOR;
    private static Map<String, Path> URL_FILES;
    private static Map<String, VersionAssetsInfo> VERSION_ASSET_INFO;
    private static Map<String, Map<String, String>> ASSET_MAPPING;
    private static JsonArray VERSIONS_ARRAY;

    static void haltAndFlush() {
        if (EXECUTOR != null) {
            boolean successfullyTerminated;
            InterruptedException exception = null;
            try {
                EXECUTOR.shutdown();
                successfullyTerminated = EXECUTOR.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                successfullyTerminated = false;
                exception = e;
            }
            if (!successfullyTerminated) {
                AssetMoverAPI.LOGGER.fatal("Executor interrupted!", (Throwable)exception);
            } else {
                AssetMoverAPI.LOGGER.info("Downloading and moving of assets complete!");
            }
            EXECUTOR = null;
        }
        AssetMoverAPI.LOGGER.info("Clearing cache...");
        URL_FILES = null;
        VERSION_ASSET_INFO = null;
        ASSET_MAPPING = null;
        VERSIONS_ARRAY = null;
    }

    static void fromMinecraftVersion(String version, Map<String, String> assets) throws IOException {
        File mcFolder = AssetMoverHelper.getMinecraftDirectory();
        File versionsFolder = new File(mcFolder, "versions");
        JsonObject versionObject = AssetMoverHelper.getVersionJson(version, versionsFolder);
        if (versionObject != null) {
            AssetMoverHelper.scanAndMoveMinecraftAssets(version, mcFolder, versionsFolder, versionObject, assets);
        } else {
            AssetMoverAPI.LOGGER.fatal("Could not get assets from Minecraft {}", (Object)version);
        }
    }

    static Path getCurseForgeMod(String projectId, String fileId) throws IOException, URISyntaxException {
        JsonObject reqData;
        Path file = URL_FILES.get(projectId + "-" + fileId);
        if (file != null) {
            return file;
        }
        long start = System.currentTimeMillis();
        URL url = new URL(String.format("https://api.curse.tools/v1/cf/mods/%s/files/%s", projectId, fileId));
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", USER_AGENT);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), Charsets.UTF_8));){
            reqData = new JsonParser().parse((Reader)br).getAsJsonObject().getAsJsonObject("data");
        }
        URL downloadUrl = new URL(reqData.get("downloadUrl").getAsString());
        con = (HttpURLConnection)downloadUrl.openConnection();
        con.setRequestProperty("User-Agent", USER_AGENT);
        file = AssetMoverHelper.downloadToTempJar(con.getInputStream(), projectId + "-" + fileId);
        URL_FILES.put(downloadUrl.toURI().toString(), file);
        AssetMoverAPI.LOGGER.info("CurseForge mod downloaded in {}", (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
        return file;
    }

    static Path getFileFromUrl(URL url, String tempFileName) throws IOException, URISyntaxException {
        long start = System.currentTimeMillis();
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", USER_AGENT);
        Path file = AssetMoverHelper.downloadToTempJar(con.getInputStream(), tempFileName);
        AssetMoverAPI.LOGGER.info("File downloaded in {}", (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
        URL_FILES.put(url.toURI().toString(), file);
        return file;
    }

    private static JsonObject getVersionJson(String version, File versionsFolder) throws IOException {
        VersionAssetsInfo info = VERSION_ASSET_INFO.get(version);
        JsonObject versionObject = null;
        if (info != null && info.versionJson != null) {
            versionObject = info.versionJson;
        }
        if (versionObject == null) {
            File versionFile = new File(versionsFolder, version + ".json");
            if (versionFile.exists()) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(versionFile));
                    Object object = null;
                    try {
                        versionObject = new JsonParser().parse((Reader)br).getAsJsonObject();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (br != null) {
                            if (object != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                br.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while reading {}", (Object)(version + ".json"));
                    AssetMoverAPI.LOGGER.fatal("Attempting to Re-Download {} from Mojang", (Object)(version + ".json"), (Object)e);
                }
            }
            if (versionObject == null) {
                Throwable throwable;
                BufferedReader br;
                HttpURLConnection con;
                if (VERSIONS_ARRAY == null) {
                    long start = System.currentTimeMillis();
                    URL manifestUrl = new URL(VERSIONS_MANIFEST);
                    con = (HttpURLConnection)manifestUrl.openConnection();
                    con.setRequestProperty("User-Agent", USER_AGENT);
                    try {
                        br = new BufferedReader(new InputStreamReader(con.getInputStream(), Charsets.UTF_8));
                        throwable = null;
                        try {
                            VERSIONS_ARRAY = new JsonParser().parse((Reader)br).getAsJsonObject().getAsJsonArray("versions");
                            AssetMoverAPI.LOGGER.info("Manifest downloaded in {}", (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (br != null) {
                                if (throwable != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    br.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while downloading versions manifest", (Throwable)e);
                    }
                }
                if (VERSIONS_ARRAY != null) {
                    URL versionUrl = null;
                    for (JsonElement versionElement : VERSIONS_ARRAY) {
                        JsonObject versionObj;
                        String id;
                        if (!(versionElement instanceof JsonObject) || !version.equals(id = (versionObj = versionElement.getAsJsonObject()).get("id").getAsString())) continue;
                        versionUrl = new URL(versionObj.get("url").getAsString());
                        break;
                    }
                    if (versionUrl == null) {
                        AssetMoverAPI.LOGGER.fatal("Invalid version detetected, {} is not present in the manifest json", (Object)version);
                    } else {
                        long start = System.currentTimeMillis();
                        con = (HttpURLConnection)versionUrl.openConnection();
                        con.setRequestProperty("User-Agent", USER_AGENT);
                        try {
                            br = new BufferedReader(new InputStreamReader(con.getInputStream(), Charsets.UTF_8));
                            throwable = null;
                            try {
                                versionObject = new JsonParser().parse((Reader)br).getAsJsonObject();
                                AssetMoverAPI.LOGGER.info("Manifest of {} downloaded in {}", (Object)version, (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (br != null) {
                                    if (throwable != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        br.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while downloading versions json", (Throwable)e);
                        }
                    }
                }
            }
            if (versionObject != null) {
                info = new VersionAssetsInfo();
                info.versionJson = versionObject;
                VERSION_ASSET_INFO.put(version, info);
            }
        }
        return versionObject;
    }

    private static void scanAndMoveMinecraftAssets(String version, File mcFolder, File versionFolder, JsonObject versionObject, Map<String, String> assets) throws IOException {
        JsonObject assetIndexObject = versionObject.getAsJsonObject("assetIndex");
        String assetVersion = assetIndexObject.get("id").getAsString();
        Object2ObjectOpenHashMap objects = ASSET_MAPPING.get(assetVersion);
        VersionAssetsInfo info = VERSION_ASSET_INFO.get(version);
        if (info == null) {
            info = new VersionAssetsInfo();
        }
        if (objects == null) {
            File indexesFolder = new File(mcFolder, "assets/indexes");
            JsonObject versionIndexJsonObject = null;
            if (indexesFolder.exists()) {
                File versionIndexJson = new File(indexesFolder, assetVersion + ".json");
                if (versionIndexJson.exists()) {
                    try (BufferedReader br = new BufferedReader(new FileReader(versionIndexJson));){
                        versionIndexJsonObject = new JsonParser().parse((Reader)br).getAsJsonObject().getAsJsonObject("objects");
                    }
                    catch (IOException e) {
                        AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while reading asset index json for version {} {}", (Object)assetVersion, (Object)e);
                    }
                }
                info.assetIndexAvailableLocally = true;
            }
            if (versionIndexJsonObject == null) {
                long start = System.currentTimeMillis();
                URL assetIndexUrl = new URL(assetIndexObject.get("url").getAsString());
                HttpURLConnection con = (HttpURLConnection)assetIndexUrl.openConnection();
                con.setRequestProperty("User-Agent", USER_AGENT);
                try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), Charsets.UTF_8));){
                    versionIndexJsonObject = new JsonParser().parse((Reader)br).getAsJsonObject().getAsJsonObject("objects");
                    AssetMoverAPI.LOGGER.info("Asset index for {} downloaded in {}", (Object)assetVersion, (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
                }
                catch (IOException e) {
                    AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while downloading asset index json for version {} {}", (Object)assetVersion, (Object)e);
                }
                info.assetIndexAvailableLocally = false;
            }
            objects = new Object2ObjectOpenHashMap(versionIndexJsonObject.size());
            ASSET_MAPPING.put(assetVersion, (Map<String, String>)objects);
            for (Map.Entry elements : versionIndexJsonObject.entrySet()) {
                objects.put(elements.getKey(), ((JsonElement)elements.getValue()).getAsJsonObject().get("hash").getAsString());
            }
        }
        if (EXECUTOR == null) {
            AssetMoverAPI.LOGGER.info("Building Executor...");
            EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setPriority(3).setNameFormat("AssetMover Downloader #%d").setDaemon(true).build());
        }
        Object2ObjectOpenHashMap finalizedObjects = objects;
        VersionAssetsInfo finalizedInfo = info;
        EXECUTOR.execute(() -> {
            HttpURLConnection con;
            Iterator iter = assets.entrySet().iterator();
            while (iter.hasNext()) {
                File objectsFolder;
                Map.Entry entry = iter.next();
                String hash = (String)finalizedObjects.get(entry.getKey());
                if (hash == null && (hash = (String)finalizedObjects.get(((String)entry.getKey()).substring(7))) == null) continue;
                File to = AssetMoverAPI.PARENT_PATH.resolve((String)entry.getValue()).toFile();
                if (finalizedInfo.assetIndexAvailableLocally && (objectsFolder = new File(mcFolder, "assets/objects")).exists()) {
                    File hashFile = new File(objectsFolder, hash.substring(0, 2) + "/" + hash);
                    AssetMoverHelper.move(hashFile, to);
                    iter.remove();
                    continue;
                }
                try {
                    long start = System.currentTimeMillis();
                    URL hashUrl = new URL(RESOURCES_URL + hash.substring(0, 2) + "/" + hash);
                    con = (HttpURLConnection)hashUrl.openConnection();
                    con.setRequestProperty("User-Agent", USER_AGENT);
                    AssetMoverHelper.move(con.getInputStream(), to);
                    AssetMoverAPI.LOGGER.info("Asset '{}' downloaded in {}", entry.getKey(), (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
                    iter.remove();
                }
                catch (IOException e) {
                    AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while downloading asset '{}' {}", entry.getKey(), (Object)e);
                }
            }
            Path clientJar = null;
            if (finalizedInfo.clientJar != null) {
                clientJar = finalizedInfo.clientJar;
            } else {
                File clientJarFile = new File(versionFolder, version + "/" + version + ".jar");
                if (clientJarFile.exists()) {
                    clientJar = clientJarFile.toPath();
                } else {
                    String url = versionObject.getAsJsonObject("downloads").getAsJsonObject("client").get("url").getAsString();
                    try {
                        long start = System.currentTimeMillis();
                        URL clientJarUrl = new URL(url);
                        con = (HttpURLConnection)clientJarUrl.openConnection();
                        con.setRequestProperty("User-Agent", USER_AGENT);
                        clientJar = AssetMoverHelper.downloadToTempJar(con.getInputStream(), version + "-client");
                        AssetMoverAPI.LOGGER.info("Downloaded {}'s client jar in {}", (Object)version, (Object)AssetMoverHelper.getTime(System.currentTimeMillis() - start));
                    }
                    catch (IOException e) {
                        AssetMoverAPI.LOGGER.fatal("Unexpected error occurred while downloading Minecraft {}'s client jar {}", (Object)version, (Object)e);
                    }
                }
                finalizedInfo.clientJar = clientJar;
            }
            AssetMoverHelper.moveViaFilesystem(clientJar, assets);
        });
    }

    static Path downloadToTempJar(InputStream is, String fileName) throws IOException {
        Path tempFile = Files.createTempFile(fileName, ".jar", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    static void moveViaFilesystem(Path file, Map<String, String> assets) {
        try (FileSystem modFs = FileSystems.newFileSystem(file, null);){
            Iterator<Map.Entry<String, String>> iter = assets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                Path path = AssetMoverAPI.PARENT_PATH.resolve(entry.getValue());
                try {
                    AssetMoverHelper.move(modFs.getPath(entry.getKey(), new String[0]), path);
                    iter.remove();
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    AssetMoverAPI.LOGGER.fatal("Could not find asset '{}' to be copied over.", (Object)entry.getKey());
                }
            }
        }
        catch (IOException e) {
            AssetMoverAPI.LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    static void move(Path from, Path to) throws IOException {
        to.toFile().getParentFile().mkdirs();
        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
    }

    static void move(File from, File to) {
        try {
            to.getParentFile().mkdirs();
            com.google.common.io.Files.copy((File)from, (File)to);
        }
        catch (IOException e) {
            AssetMoverAPI.LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    static void move(InputStream from, File to) {
        to.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(to);){
            IOUtils.copy((InputStream)from, (OutputStream)out);
        }
        catch (IOException e) {
            AssetMoverAPI.LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    private static File getMinecraftDirectory() {
        switch (OS.CURRENT) {
            case LINUX: {
                return new File(System.getProperty("user.home"), ".minecraft");
            }
            case WINDOWS: {
                String appData = System.getenv("APPDATA");
                String folder = appData != null ? appData : System.getProperty("user.home");
                return new File(folder, ".minecraft");
            }
            case OSX: {
                return new File(System.getProperty("user.home"), "Library/Application Support/minecraft");
            }
        }
        return new File(System.getProperty("user.home"), "minecraft");
    }

    private static String getTime(long millis) {
        String suffix = " ms";
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (TimeUnit.MINUTES.convert(millis, TimeUnit.MILLISECONDS) > 0L) {
            suffix = " min";
            unit = TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(millis, TimeUnit.MILLISECONDS) > 0L) {
            suffix = " s";
            unit = TimeUnit.SECONDS;
        }
        double value = (double)millis / (double)TimeUnit.MILLISECONDS.convert(1L, unit);
        return String.format(Locale.ROOT, "%.4g", value) + suffix;
    }

    static {
        URL_FILES = new Object2ObjectOpenHashMap();
        VERSION_ASSET_INFO = new Object2ObjectOpenHashMap();
        ASSET_MAPPING = new Object2ObjectOpenHashMap();
    }

    private static enum OS {
        LINUX("linux", "linux", "bsd", "unix"),
        WINDOWS("windows", "win"),
        OSX("osx", "mac"),
        UNKNOWN("unknown", new String[0]);

        private final String name;
        private final String[] aliases;
        public static final OS CURRENT;

        private OS(String name, String ... aliases) {
            this.name = name;
            this.aliases = aliases;
        }

        public static OS getCurrentPlatform() {
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            for (OS os : OS.values()) {
                if (osName.contains(os.name)) {
                    return os;
                }
                for (String alias : os.aliases) {
                    if (!osName.contains(alias)) continue;
                    return os;
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name;
        }

        static {
            CURRENT = OS.getCurrentPlatform();
        }
    }

    private static class VersionAssetsInfo {
        private JsonObject versionJson;
        private boolean assetIndexAvailableLocally;
        private Path clientJar;

        private VersionAssetsInfo() {
        }
    }
}

