/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller.gui;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.api.keys.SidedPos;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.controller.gui.ChannelEditorPanel;
import mcjty.xnet.blocks.controller.gui.ConnectorEditorPanel;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import mcjty.xnet.clientinfo.ConnectedBlockClientInfo;
import mcjty.xnet.clientinfo.ConnectorClientInfo;
import mcjty.xnet.network.PacketGetChannels;
import mcjty.xnet.network.PacketGetConnectedBlocks;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiController
extends GenericGuiContainer<TileEntityController> {
    public static final String TAG_ENABLED = "enabled";
    public static final String TAG_NAME = "name";
    private WidgetList connectorList;
    private List<SidedPos> connectorPositions = new ArrayList<SidedPos>();
    private int listDirty;
    private TextField searchBar;
    private int delayedSelectedChannel = -1;
    private int delayedSelectedLine = -1;
    private SidedPos delayedSelectedConnector = null;
    private Panel channelEditPanel;
    private Panel connectorEditPanel;
    private ToggleButton[] channelButtons = new ToggleButton[8];
    private SidedPos editingConnector = null;
    private int editingChannel = -1;
    private int showingChannel = -1;
    private SidedPos showingConnector = null;
    private static GuiController openController = null;
    private EnergyBar energyBar;
    private Button copyConnector = null;
    public static List<ChannelClientInfo> fromServer_channels = null;
    public static List<ConnectedBlockClientInfo> fromServer_connectedBlocks = null;
    private boolean needsRefresh = true;

    public GuiController(TileEntityController controller, GenericContainer container) {
        super((ModBase)XNet.instance, XNetMessages.INSTANCE, (GenericTileEntity)controller, (Container)container, 0, "controller");
        openController = this;
    }

    public void func_146281_b() {
        super.func_146281_b();
        openController = null;
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, XNetMessages.INSTANCE, new ResourceLocation("xnet", "gui/controller.gui"));
        super.func_73866_w_();
        this.initializeFields();
        this.setupEvents();
        this.editingConnector = null;
        this.editingChannel = -1;
        this.refresh();
        this.listDirty = 0;
        ((TileEntityController)this.tileEntity).requestRfFromServer("xnet");
    }

    private void setupEvents() {
        this.window.event("searchbar", (source, params) -> {
            this.needsRefresh = true;
        });
        int i = 0;
        while (i < 8) {
            String channel = "channel" + (i + 1);
            int finalI = i++;
            this.window.event(channel, (source, params) -> this.selectChannelEditor(finalI));
        }
    }

    private void initializeFields() {
        this.channelEditPanel = (Panel)this.window.findChild("channeleditpanel");
        this.connectorEditPanel = (Panel)this.window.findChild("connectoreditpanel");
        this.searchBar = (TextField)this.window.findChild("searchbar");
        this.connectorList = (WidgetList)this.window.findChild("connectors");
        this.connectorList.addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(Widget<?> parent, int index) {
                GuiController.this.hilightSelectedContainer(index);
            }
        });
        for (int i = 0; i < 8; ++i) {
            String name = "channel" + (i + 1);
            this.channelButtons[i] = (ToggleButton)this.window.findChild(name);
        }
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.energyBar.setMaxValue(((TileEntityController)this.tileEntity).getCapacity());
        this.energyBar.setValue(currentRF);
    }

    private void hilightSelectedContainer(int index) {
        if (index < 0) {
            return;
        }
        ConnectedBlockClientInfo c = fromServer_connectedBlocks.get(index);
        if (c != null) {
            XNet.instance.clientInfo.hilightBlock(c.getPos().getPos(), System.currentTimeMillis() + 5000L);
            Logging.message((EntityPlayer)this.field_146297_k.field_71439_g, (String)"The block is now highlighted");
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        if (this.handleKeyUpDown(keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void keyTypedFromEvent(char typedChar, int keyCode) {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        if (this.handleKeyUpDown(keyCode)) {
            return;
        }
        super.keyTypedFromEvent(typedChar, keyCode);
    }

    private boolean handleKeyUpDown(int keyCode) {
        if (this.getSelectedChannel() == -1) {
            return false;
        }
        if (keyCode == 200) {
            int sel = this.connectorList.getSelected();
            if (sel > 0) {
                this.connectorList.setSelected(--sel);
                this.selectConnectorEditor(this.connectorPositions.get(sel), this.getSelectedChannel());
            }
            return true;
        }
        if (keyCode == 208) {
            int sel = this.connectorList.getSelected();
            if (sel != -1 && sel < this.connectorList.getChildCount() - 1) {
                this.connectorList.setSelected(++sel);
                this.selectConnectorEditor(this.connectorPositions.get(sel), this.getSelectedChannel());
            }
            return true;
        }
        return false;
    }

    private boolean handleClipboard(int keyCode) {
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            if (keyCode == 46) {
                if (this.getSelectedChannel() != -1) {
                    this.copyConnector();
                } else {
                    GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing selected!");
                }
                return true;
            }
            if (keyCode == 47) {
                if (this.getSelectedChannel() != -1) {
                    this.pasteConnector();
                } else {
                    GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing selected!");
                }
                return true;
            }
        }
        return false;
    }

    private void selectChannelEditor(int finalI) {
        this.editingChannel = -1;
        this.showingConnector = null;
        for (int j = 0; j < 8; ++j) {
            if (j == finalI) continue;
            this.channelButtons[j].setPressed(false);
            this.editingChannel = finalI;
        }
    }

    private void removeConnector(SidedPos sidedPos) {
        this.sendServerCommand(XNetMessages.INSTANCE, "controller.removeConnector", TypedMap.builder().put(TileEntityController.PARAM_CHANNEL, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)sidedPos.getPos()).put(TileEntityController.PARAM_SIDE, (Object)sidedPos.getSide().ordinal()).build());
        this.refresh();
    }

    private void createConnector(SidedPos sidedPos) {
        this.sendServerCommand(XNetMessages.INSTANCE, "controller.createConnector", TypedMap.builder().put(TileEntityController.PARAM_CHANNEL, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)sidedPos.getPos()).put(TileEntityController.PARAM_SIDE, (Object)sidedPos.getSide().ordinal()).build());
        this.refresh();
    }

    private void removeChannel() {
        GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Really remove channel " + (this.getSelectedChannel() + 1) + "?", parent -> {
            this.sendServerCommand(XNetMessages.INSTANCE, "controller.removeChannel", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).build());
            this.refresh();
        });
    }

    private void createChannel(String typeId) {
        this.sendServerCommand(XNetMessages.INSTANCE, "controller.createChannel", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_TYPE, (Object)typeId).build());
        this.refresh();
    }

    public void refresh() {
        fromServer_channels = null;
        fromServer_connectedBlocks = null;
        this.showingChannel = -1;
        this.showingConnector = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private void selectConnectorEditor(SidedPos sidedPos, int finalI) {
        this.editingConnector = sidedPos;
        this.selectChannelEditor(finalI);
    }

    private void refreshChannelEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingChannel != -1 && this.showingChannel != this.editingChannel) {
            this.showingChannel = this.editingChannel;
            this.channelButtons[this.editingChannel].setPressed(true);
            this.copyConnector = null;
            this.channelEditPanel.removeChildren();
            if (this.channelButtons[this.editingChannel].isPressed()) {
                ChannelClientInfo info = fromServer_channels.get(this.editingChannel);
                if (info != null) {
                    ChannelEditorPanel editor = new ChannelEditorPanel(this.channelEditPanel, this.field_146297_k, this, this.editingChannel);
                    editor.label("Channel " + (this.editingChannel + 1)).shift(5).toggle(TAG_ENABLED, "Enable processing on this channel", info.isEnabled()).shift(5).text(TAG_NAME, "Channel name", info.getChannelName(), 65);
                    info.getChannelSettings().createGui(editor);
                    Button remove = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("x")).setTextOffset(0, -1)).setTooltips(new String[]{"Remove this channel"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(151, 1, 9, 10))).addButtonEvent(parent -> this.removeChannel());
                    this.channelEditPanel.addChild((Widget)remove);
                    editor.setState(info.getChannelSettings());
                    Button copyChannel = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("C")).setTooltips(new String[]{"Copy this channel to", "the clipboard"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(134, 19, 25, 14))).addButtonEvent(parent -> this.copyChannel());
                    this.channelEditPanel.addChild((Widget)copyChannel);
                    this.copyConnector = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("C")).setTooltips(new String[]{"Copy this connector", "to the clipboard"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(114, 19, 25, 14))).addButtonEvent(parent -> this.copyConnector());
                    this.channelEditPanel.addChild((Widget)this.copyConnector);
                } else {
                    ChoiceLabel type = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 3, 95, 14));
                    for (IChannelType channelType : XNet.xNetApi.getChannels().values()) {
                        type.addChoices(new String[]{channelType.getID()});
                    }
                    Button create = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Create")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 3, 53, 14))).addButtonEvent(parent -> this.createChannel(type.getCurrentChoice()));
                    Button paste = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Paste")).setTooltips(new String[]{"Create a new channel", "from the clipboard"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 17, 53, 14))).addButtonEvent(parent -> this.pasteChannel());
                    ((Panel)((Panel)this.channelEditPanel.addChild((Widget)type)).addChild((Widget)create)).addChild((Widget)paste);
                }
            }
        } else if (this.showingChannel != -1 && this.editingChannel == -1) {
            this.showingChannel = -1;
            this.channelEditPanel.removeChildren();
        }
    }

    public static void showMessage(Minecraft mc, Gui gui, WindowManager windowManager, int x, int y, String title) {
        GuiController.showMessage(mc, gui, windowManager, x, y, title, null);
    }

    public static void showMessage(Minecraft mc, Gui gui, WindowManager windowManager, int x, int y, String title, ButtonEvent okEvent) {
        Panel ask = (Panel)((Panel)new Panel(mc, gui).setLayout((Layout)new VerticalLayout()).setFilledBackground(-10066330, -5592406)).setFilledRectThickness(1);
        ask.setBounds(new Rectangle(x, y, 200, 40));
        Window askWindow = windowManager.createModalWindow((AbstractContainerWidget)ask);
        ask.addChild((Widget)new Label(mc, gui).setText(title));
        Panel buttons = (Panel)((Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).setDesiredWidth(100)).setDesiredHeight(18);
        if (okEvent != null) {
            buttons.addChild((Widget)((Button)new Button(mc, gui).setText("Cancel")).addButtonEvent(parent -> windowManager.closeWindow(askWindow)));
            buttons.addChild((Widget)((Button)new Button(mc, gui).setText("OK")).addButtonEvent(parent -> {
                windowManager.closeWindow(askWindow);
                okEvent.buttonClicked(parent);
            }));
        } else {
            buttons.addChild((Widget)((Button)new Button(mc, gui).setText("OK")).addButtonEvent(parent -> windowManager.closeWindow(askWindow)));
        }
        ask.addChild((Widget)buttons);
    }

    private void copyConnector() {
        if (this.editingConnector != null) {
            this.sendServerCommand(XNetMessages.INSTANCE, "controller.copyConnector", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)this.editingConnector.getPos()).put(TileEntityController.PARAM_SIDE, (Object)this.editingConnector.getSide().ordinal()).build());
        }
    }

    private void copyChannel() {
        GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.GREEN + "Copied channel");
        this.sendServerCommand(XNetMessages.INSTANCE, "controller.copyChannel", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).build());
    }

    public static void showError(String error) {
        if (openController != null) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiController.showMessage(mc, (Gui)openController, openController.getWindowManager(), 50, 50, TextFormatting.RED + error);
        }
    }

    public static void toClipboard(String json) {
        try {
            StringSelection selection = new StringSelection(json);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
        catch (Exception e) {
            GuiController.showError("Error copying to clipboard!");
        }
    }

    private void pasteConnector() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String json = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (json.length() > 26000) {
                GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard too large!");
                return;
            }
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            String type = root.get("type").getAsString();
            IChannelType channelType = XNet.xNetApi.findType(type);
            if (channelType == null) {
                GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Unsupported channel type: " + type + "!");
                return;
            }
            this.sendServerCommand(XNetMessages.INSTANCE, "controller.pasteConnector", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)this.editingConnector.getPos()).put(TileEntityController.PARAM_SIDE, (Object)this.editingConnector.getSide().ordinal()).put(TileEntityController.PARAM_JSON, (Object)json).build());
            if (this.connectorList.getSelected() != -1) {
                this.delayedSelectedChannel = this.getSelectedChannel();
                this.delayedSelectedLine = this.connectorList.getSelected();
                this.delayedSelectedConnector = this.connectorPositions.get(this.connectorList.getSelected());
            }
            this.refresh();
        }
        catch (UnsupportedFlavorException e) {
            GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard does not contain connector!");
        }
        catch (Exception e) {
            GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error reading from clipboard!");
        }
    }

    private void pasteChannel() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String json = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (json.length() > 26000) {
                GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard too large!");
                return;
            }
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            String type = root.get("type").getAsString();
            IChannelType channelType = XNet.xNetApi.findType(type);
            if (channelType == null) {
                GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Unsupported channel type: " + type + "!");
                return;
            }
            this.sendServerCommand(XNetMessages.INSTANCE, "controller.pasteChannel", TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_JSON, (Object)json).build());
            this.refresh();
        }
        catch (UnsupportedFlavorException e) {
            GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard does not contain channel!");
        }
        catch (Exception e) {
            GuiController.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error reading from clipboard!");
        }
    }

    private ConnectorClientInfo findClientInfo(ChannelClientInfo info, SidedPos p) {
        for (ConnectorClientInfo connector : info.getConnectors().values()) {
            if (!connector.getPos().equals(p)) continue;
            return connector;
        }
        return null;
    }

    private void refreshConnectorEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingConnector != null && !this.editingConnector.equals(this.showingConnector)) {
            this.showingConnector = this.editingConnector;
            this.connectorEditPanel.removeChildren();
            ChannelClientInfo info = fromServer_channels.get(this.editingChannel);
            if (info != null) {
                ConnectorClientInfo clientInfo = this.findClientInfo(info, this.editingConnector);
                if (clientInfo != null) {
                    EnumFacing side = clientInfo.getPos().getSide();
                    SidedConsumer sidedConsumer = new SidedConsumer(clientInfo.getConsumerId(), side.func_176734_d());
                    ConnectorClientInfo connectorInfo = info.getConnectors().get(sidedConsumer);
                    Button remove = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("x")).setTextOffset(0, -1)).setTooltips(new String[]{"Remove this connector"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(151, 1, 9, 10))).addButtonEvent(parent -> this.removeConnector(this.editingConnector));
                    ConnectorEditorPanel editor = new ConnectorEditorPanel(this.connectorEditPanel, this.field_146297_k, this, this.editingChannel, this.editingConnector);
                    connectorInfo.getConnectorSettings().createGui(editor);
                    this.connectorEditPanel.addChild((Widget)remove);
                    editor.setState(connectorInfo.getConnectorSettings());
                } else {
                    Button create = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Create")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(85, 20, 60, 14))).addButtonEvent(parent -> this.createConnector(this.editingConnector));
                    this.connectorEditPanel.addChild((Widget)create);
                    Button paste = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Paste")).setTooltips(new String[]{"Create a new connector", "from the clipboard"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(85, 40, 60, 14))).addButtonEvent(parent -> this.pasteConnector());
                    this.connectorEditPanel.addChild((Widget)paste);
                }
            }
        } else if (this.showingConnector != null && this.editingConnector == null) {
            this.showingConnector = null;
            this.connectorEditPanel.removeChildren();
        }
    }

    private void requestListsIfNeeded() {
        if (fromServer_channels != null && fromServer_connectedBlocks != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetChannels(((TileEntityController)this.tileEntity).func_174877_v()));
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetConnectedBlocks(((TileEntityController)this.tileEntity).func_174877_v()));
            this.listDirty = 10;
            this.showingChannel = -1;
            this.showingConnector = null;
        }
    }

    private int getSelectedChannel() {
        for (int i = 0; i < 8; ++i) {
            if (!this.channelButtons[i].isPressed()) continue;
            return i;
        }
        return -1;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.connectorList.removeChildren();
        this.connectorPositions.clear();
        int sel = this.connectorList.getSelected();
        BlockPos prevPos = null;
        String selectedText = this.searchBar.getText().trim().toLowerCase();
        for (ConnectedBlockClientInfo connectedBlock : fromServer_connectedBlocks) {
            BlockRender br;
            SidedPos sidedPos = connectedBlock.getPos();
            BlockPos coordinate = sidedPos.getPos();
            String name = connectedBlock.getName();
            String controllerName = connectedBlock.getName();
            String blockUnlocName = connectedBlock.getBlockUnlocName();
            String blockName = I18n.func_135052_a((String)blockUnlocName, (Object[])new Object[0]).trim();
            int color = StyleConfig.colorTextInListNormal;
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0));
            if (!selectedText.isEmpty() && (controllerName.isEmpty() && blockName.toLowerCase().contains(selectedText) || controllerName.toLowerCase().contains(selectedText))) {
                panel.setFilledBackground(-2232662);
            }
            if (coordinate.equals(prevPos)) {
                br = new BlockRender(this.field_146297_k, (Gui)this);
            } else {
                br = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)connectedBlock.getConnectedBlock());
                prevPos = coordinate;
            }
            br.setUserObject((Object)"block");
            panel.addChild((Widget)br);
            if (!name.isEmpty()) {
                br.setTooltips(new String[]{TextFormatting.GREEN + "Connector: " + TextFormatting.WHITE + name, TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            } else {
                br.setTooltips(new String[]{TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            }
            panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(sidedPos.getSide().func_176610_l().substring(0, 1).toUpperCase())).setColor(color)).setDesiredWidth(18));
            int i = 0;
            while (i < 8) {
                ConnectorClientInfo clientInfo;
                Button but = (Button)new Button(this.field_146297_k, (Gui)this).setDesiredWidth(14);
                ChannelClientInfo info = fromServer_channels.get(i);
                if (info != null && (clientInfo = this.findClientInfo(info, sidedPos)) != null) {
                    String indicator;
                    IndicatorIcon icon = clientInfo.getConnectorSettings().getIndicatorIcon();
                    if (icon != null) {
                        but.setImage(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    but.setText((indicator = clientInfo.getConnectorSettings().getIndicator()) != null ? indicator : "");
                }
                int finalI = i++;
                but.addButtonEvent(parent -> this.selectConnectorEditor(sidedPos, finalI));
                panel.addChild((Widget)but);
            }
            this.connectorList.addChild((Widget)panel);
            this.connectorPositions.add(sidedPos);
        }
        this.connectorList.setSelected(sel);
        if (this.delayedSelectedChannel != -1) {
            this.connectorList.setSelected(this.delayedSelectedLine);
            this.selectConnectorEditor(this.delayedSelectedConnector, this.delayedSelectedChannel);
        }
        this.delayedSelectedChannel = -1;
        this.delayedSelectedLine = -1;
        this.delayedSelectedConnector = null;
    }

    private boolean listsReady() {
        return fromServer_channels != null && fromServer_connectedBlocks != null;
    }

    protected void func_146976_a(float v, int x1, int x2) {
        this.requestListsIfNeeded();
        this.populateList();
        this.refreshChannelEditor();
        this.refreshConnectorEditor();
        if (this.listsReady() && this.copyConnector != null && this.editingChannel != -1) {
            ChannelClientInfo info = fromServer_channels.get(this.editingChannel);
            ConnectorClientInfo clientInfo = this.findClientInfo(info, this.editingConnector);
            this.copyConnector.setEnabled(clientInfo != null);
        }
        if (fromServer_channels != null) {
            for (int i = 0; i < 8; ++i) {
                String channel = String.valueOf(i + 1);
                ChannelClientInfo info = fromServer_channels.get(i);
                if (info != null) {
                    String indicator;
                    IndicatorIcon icon = info.getChannelSettings().getIndicatorIcon();
                    if (icon != null) {
                        this.channelButtons[i].setImage(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    if ((indicator = info.getChannelSettings().getIndicator()) != null) {
                        this.channelButtons[i].setText(indicator + channel);
                        continue;
                    }
                    this.channelButtons[i].setText(channel);
                    continue;
                }
                this.channelButtons[i].setImage(null, 0, 0, 0, 0);
                this.channelButtons[i].setText(channel);
            }
        }
        this.drawWindow();
        int channel = this.getSelectedChannel();
        if (channel != -1) {
            int x = (int)this.window.getToplevel().getBounds().getX();
            int y = (int)this.window.getToplevel().getBounds().getY();
            RenderHelper.drawVerticalGradientRect((int)(x + channel * 14 + 41), (int)(y + 22), (int)(x + channel * 14 + 41 + 12), (int)(y + 230), (int)0x33AAFFFF, (int)0x33AAFFFF);
        }
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((TileEntityController)this.tileEntity).requestRfFromServer("xnet");
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && "block".equals(widget.getUserObject())) {
            return;
        }
        super.drawStackTooltips(mouseX, mouseY);
    }
}

