/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.metatileentities.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregicality.multiblocks.api.capability.IParallelHatch;
import gregicality.multiblocks.api.metatileentity.GCYMMultiblockAbility;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityParallelHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IParallelHatch>,
IParallelHatch {
    private static final int MIN_PARALLEL = 1;
    private final int maxParallel;
    private int currentParallel;

    public MetaTileEntityParallelHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.currentParallel = this.maxParallel = (int)Math.pow(4.0, tier - 4);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityParallelHatch(this.metaTileEntityId, this.getTier());
    }

    @Override
    public int getCurrentParallel() {
        return this.currentParallel;
    }

    public void setCurrentParallel(int parallelAmount) {
        this.currentParallel = MathHelper.func_76125_a((int)(this.currentParallel + parallelAmount), (int)1, (int)this.maxParallel);
    }

    protected ModularUI createUI(@NotNull EntityPlayer entityPlayer) {
        ServerWidgetGroup parallelAmountGroup = new ServerWidgetGroup(() -> true);
        parallelAmountGroup.addWidget((Widget)new ImageWidget(62, 36, 53, 20, (IGuiTexture)GuiTextures.DISPLAY).setTooltip("gcym.machine.parallel_hatch.display"));
        parallelAmountGroup.addWidget((Widget)new IncrementButtonWidget(118, 36, 30, 20, 1, 4, 16, 64, this::setCurrentParallel).setDefaultTooltip().setShouldClientCallback(false));
        parallelAmountGroup.addWidget((Widget)new IncrementButtonWidget(29, 36, 30, 20, -1, -4, -16, -64, this::setCurrentParallel).setDefaultTooltip().setShouldClientCallback(false));
        parallelAmountGroup.addWidget((Widget)new TextFieldWidget2(63, 42, 51, 20, this::getParallelAmountToString, val -> {
            if (val != null && !val.isEmpty()) {
                this.setCurrentParallel(Integer.parseInt(val));
            }
        }).setCentered(true).setNumbersOnly(1, this.maxParallel).setMaxLength(3).setValidator(MetaTileEntityParallelHatch.getTextFieldValidator(() -> this.maxParallel)));
        return ModularUI.defaultBuilder().widget((Widget)new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget((Widget)parallelAmountGroup).bindPlayerInventory(entityPlayer.field_71071_by, (IGuiTexture)GuiTextures.SLOT, 0).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public String getParallelAmountToString() {
        return Integer.toString(this.currentParallel);
    }

    @NotNull
    public static Function<String, String> getTextFieldValidator(IntSupplier maxSupplier) {
        return val -> {
            int num;
            if (val.isEmpty()) {
                return String.valueOf(1);
            }
            int max = maxSupplier.getAsInt();
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException ignored) {
                return String.valueOf(max);
            }
            if (num < 1) {
                return String.valueOf(1);
            }
            if (num > max) {
                return String.valueOf(max);
            }
            return val;
        };
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gcym.machine.parallel_hatch.tooltip", (Object[])new Object[]{this.maxParallel}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
    }

    public MultiblockAbility<IParallelHatch> getAbility() {
        return GCYMMultiblockAbility.PARALLEL_HATCH;
    }

    public void registerAbilities(@NotNull List<IParallelHatch> list) {
        list.add(this);
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            OrientedOverlayRenderer overlayRenderer = this.getTier() == 5 ? GCYMTextures.PARALLEL_HATCH_MK1_OVERLAY : (this.getTier() == 6 ? GCYMTextures.PARALLEL_HATCH_MK2_OVERLAY : (this.getTier() == 7 ? GCYMTextures.PARALLEL_HATCH_MK3_OVERLAY : GCYMTextures.PARALLEL_HATCH_MK4_OVERLAY));
            if (this.getController() != null && this.getController() instanceof RecipeMapMultiblockController) {
                overlayRenderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.getController().isActive(), ((IControllable)this.getController().getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null)).isWorkingEnabled());
            } else {
                overlayRenderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), false, false);
            }
        }
    }

    public boolean canPartShare() {
        return false;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        data.func_74768_a("currentParallel", this.currentParallel);
        return super.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.currentParallel = data.func_74762_e("currentParallel");
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.currentParallel);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.currentParallel = buf.readInt();
    }
}

