/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.metatileentities.multiblock.generator;

import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntitySteamEngine
extends FuelMultiblockController {
    public MetaTileEntitySteamEngine(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.STEAM_TURBINE_FUELS, 2);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntitySteamEngine(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"#XX", "XEX", "#XX"}).aisle(new String[]{"XXX", "XGX", "XMX"}).aisle(new String[]{"#XX", "XGX", "#XX"}).aisle(new String[]{"#XX", "#SX", "#XX"}).where('S', this.selfPredicate()).where('X', MetaTileEntitySteamEngine.states((IBlockState[])new IBlockState[]{MetaTileEntitySteamEngine.getCasingState()}).setMinGlobalLimited(18).or(this.autoAbilities(false, true, true, true, true, true, false))).where('G', MetaTileEntitySteamEngine.states((IBlockState[])new IBlockState[]{MetaTileEntitySteamEngine.getCasingState2()})).where('E', MetaTileEntitySteamEngine.energyOutputPredicate()).where('M', MetaTileEntitySteamEngine.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('#', MetaTileEntitySteamEngine.any()).build();
    }

    private static TraceabilityPredicate energyOutputPredicate() {
        return MetaTileEntitySteamEngine.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])((List)MultiblockAbility.REGISTRY.get(MultiblockAbility.OUTPUT_ENERGY)).stream().filter(mte -> {
            IEnergyContainer container = (IEnergyContainer)mte.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
            return container != null && container.getOutputVoltage() <= GTValues.V[2];
        }).toArray(MetaTileEntity[]::new))).addTooltip("gregtech.multiblock.pattern.error.limited.1", new Object[]{GTValues.VN[1]}).addTooltip("gregtech.multiblock.pattern.error.limited.0", new Object[]{GTValues.VN[2]});
    }

    private static IBlockState getCasingState() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState(BlockLargeMultiblockCasing.CasingType.STEAM_CASING);
    }

    private static IBlockState getCasingState2() {
        return MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.BRONZE_GEARBOX);
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gcym.machine.steam_engine.tooltip.1", (Object[])new Object[]{GTValues.VNF[2]}));
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GCYMTextures.STEAM_CASING;
    }

    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return GCYMTextures.STEAM_ENGINE_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public void runMufflerEffect(float xPos, float yPos, float zPos, float xSpd, float ySpd, float zSpd) {
        this.getWorld().func_175688_a(EnumParticleTypes.CLOUD, (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
    }
}

