/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.unification.properties;

import com.google.common.collect.ImmutableList;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.stack.MaterialStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AlloyBlastPropertyAddition {
    private AlloyBlastPropertyAddition() {
    }

    public static void init() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (material.hasFlag(GCYMMaterialFlags.DISABLE_ALLOY_PROPERTY)) continue;
            AlloyBlastPropertyAddition.addAlloyBlastProperty(material);
        }
    }

    private static void addAlloyBlastProperty(@NotNull Material material) {
        ImmutableList components = material.getMaterialComponents();
        if (components.size() < 2) {
            return;
        }
        BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        if (blastProperty == null) {
            return;
        }
        if (!material.hasProperty(PropertyKey.FLUID)) {
            return;
        }
        if (components.stream().filter(AlloyBlastPropertyAddition::isMaterialStackFluidOnly).limit(3L).count() > 2L) {
            return;
        }
        material.setProperty(GCYMPropertyKey.ALLOY_BLAST, (IMaterialProperty)new AlloyBlastProperty(material.getBlastTemperature()));
    }

    private static boolean isMaterialStackFluidOnly(@NotNull MaterialStack ms) {
        return !ms.material.hasProperty(PropertyKey.DUST) && ms.material.hasProperty(PropertyKey.FLUID);
    }
}

