/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

final class EventTrackerData {
    final Set<Class> VALID_OBJECTS = new HashSet<Class>();
    final Set<Class> INVALID_OBJECTS = new HashSet<Class>();
    final Set<Class> CURRENTLY_SCANNING = new HashSet<Class>();
    public boolean DEBUG = false;

    EventTrackerData() {
    }

    public EventTrackerData initDefaults() {
        this.initJavaDefaults();
        this.VALID_OBJECTS.add(BlockPos.class);
        this.VALID_OBJECTS.add(Vec3d.class);
        this.VALID_OBJECTS.add(ResourceLocation.class);
        this.INVALID_OBJECTS.add(Entity.class);
        this.INVALID_OBJECTS.add(World.class);
        this.INVALID_OBJECTS.add(NBTBase.class);
        return this;
    }

    public EventTrackerData initJavaDefaults() {
        this.VALID_OBJECTS.add(Integer.class);
        this.VALID_OBJECTS.add(Double.class);
        this.VALID_OBJECTS.add(Float.class);
        this.VALID_OBJECTS.add(Long.class);
        this.VALID_OBJECTS.add(String.class);
        this.VALID_OBJECTS.add(Byte.class);
        this.VALID_OBJECTS.add(Short.class);
        this.VALID_OBJECTS.add(Date.class);
        this.VALID_OBJECTS.add(Object.class);
        return this;
    }

    public boolean isValidType(Class objClass) {
        return this.isValidType(objClass, 0);
    }

    private boolean isValidType(Class objClass, int depth) {
        this.debug("checking " + objClass, depth);
        if (Throwable.class.isAssignableFrom(objClass)) {
            this.debug("isThrowable " + objClass, depth);
            return true;
        }
        if (this.VALID_OBJECTS.contains(objClass)) {
            this.debug("isValid " + objClass, depth);
            return true;
        }
        if (this.INVALID_OBJECTS.contains(objClass)) {
            this.debug("isInvalid " + objClass, depth);
            return false;
        }
        if (!this.scanClass(objClass, depth)) {
            this.debug("adding to invalid " + objClass, depth);
            this.INVALID_OBJECTS.add(objClass);
            return false;
        }
        this.debug("adding to valid " + objClass, depth);
        this.VALID_OBJECTS.add(objClass);
        return true;
    }

    boolean scanClass(Class objClass, int depth) {
        this.CURRENTLY_SCANNING.add(objClass);
        this.debug("scanning " + objClass, depth);
        if (objClass.getSuperclass() != null && !this.isValidType(objClass.getSuperclass(), depth + 1)) {
            return false;
        }
        Field[] objFields = objClass.getDeclaredFields();
        boolean isValid = true;
        for (Field objField : objFields) {
            this.debug("field " + objField, depth);
            if (!Modifier.isFinal(objField.getModifiers())) {
                this.debug("notFinal " + objField, depth);
                isValid = false;
                continue;
            }
            if (!this.CURRENTLY_SCANNING.contains(objField.getType())) {
                isValid = isValid && this.isValidType(objField.getType(), depth + 1);
                continue;
            }
            this.debug("already scanning " + objField, depth);
        }
        this.debug("done scanning " + objClass + " -> isValid=" + isValid, depth);
        this.CURRENTLY_SCANNING.remove(objClass);
        return isValid;
    }

    private void debug(String msg, int depth) {
        if (this.DEBUG) {
            System.out.println("EvenTrackerData: " + StringUtils.repeat((String)"\t", (int)depth) + msg);
        }
    }
}

