/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tile;

import icbm.classic.lib.tile.ITick;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class TickAction
implements ITick {
    public final BiFunction<Integer, Boolean, Boolean> shouldRun;
    public final Consumer<Integer> action;

    public TickAction(int ticks, Consumer<Integer> action) {
        this.shouldRun = (t, server) -> t % ticks == 0;
        this.action = action;
    }

    public TickAction(int ticks, boolean isServer, Consumer<Integer> action) {
        this.shouldRun = (t, server) -> t % ticks == 0 && server == isServer;
        this.action = action;
    }

    public TickAction(int ticks, boolean isServer, Runnable action) {
        this.shouldRun = (t, server) -> t % ticks == 0 && server == isServer;
        this.action = t -> action.run();
    }

    public TickAction(Supplier<Boolean> shouldRun, Runnable action) {
        this.shouldRun = (t, server) -> (Boolean)shouldRun.get();
        this.action = t -> action.run();
    }

    @Override
    public void update(int tick, boolean isServer) {
        if (this.shouldRun.apply(tick, isServer).booleanValue()) {
            this.action.accept(tick);
        }
    }

    @Generated
    public BiFunction<Integer, Boolean, Boolean> getShouldRun() {
        return this.shouldRun;
    }

    @Generated
    public Consumer<Integer> getAction() {
        return this.action;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TickAction)) {
            return false;
        }
        TickAction other = (TickAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BiFunction<Integer, Boolean, Boolean> this$shouldRun = this.getShouldRun();
        BiFunction<Integer, Boolean, Boolean> other$shouldRun = other.getShouldRun();
        if (this$shouldRun == null ? other$shouldRun != null : !this$shouldRun.equals(other$shouldRun)) {
            return false;
        }
        Consumer<Integer> this$action = this.getAction();
        Consumer<Integer> other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TickAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BiFunction<Integer, Boolean, Boolean> $shouldRun = this.getShouldRun();
        result = result * 59 + ($shouldRun == null ? 43 : $shouldRun.hashCode());
        Consumer<Integer> $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TickAction(shouldRun=" + this.getShouldRun() + ", action=" + this.getAction() + ")";
    }

    @Generated
    public TickAction(BiFunction<Integer, Boolean, Boolean> shouldRun, Consumer<Integer> action) {
        this.shouldRun = shouldRun;
        this.action = action;
    }
}

