/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.saving;

import icbm.classic.api.reg.obj.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.lib.saving.INbtSaveNode;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import icbm.classic.lib.saving.nodes.SaveBuildableObject;
import icbm.classic.lib.saving.nodes.SaveBuildableObjectList;
import icbm.classic.lib.saving.nodes.SaveNodeBlockPos;
import icbm.classic.lib.saving.nodes.SaveNodeBlockState;
import icbm.classic.lib.saving.nodes.SaveNodeBoolean;
import icbm.classic.lib.saving.nodes.SaveNodeByte;
import icbm.classic.lib.saving.nodes.SaveNodeCompoundTag;
import icbm.classic.lib.saving.nodes.SaveNodeDouble;
import icbm.classic.lib.saving.nodes.SaveNodeEnum;
import icbm.classic.lib.saving.nodes.SaveNodeFacing;
import icbm.classic.lib.saving.nodes.SaveNodeFloat;
import icbm.classic.lib.saving.nodes.SaveNodeInteger;
import icbm.classic.lib.saving.nodes.SaveNodeItemStack;
import icbm.classic.lib.saving.nodes.SaveNodePos;
import icbm.classic.lib.saving.nodes.SaveNodeResourceLocation;
import icbm.classic.lib.saving.nodes.SaveNodeString;
import icbm.classic.lib.saving.nodes.SaveNodeUUID;
import icbm.classic.lib.saving.nodes.SaveNodeVec3d;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;

public class NbtSaveRoot<SaveObject>
implements INbtSaveNode<SaveObject, NBTTagCompound> {
    private final String name;
    private final NbtSaveHandler<SaveObject> handler;
    private final NbtSaveRoot<SaveObject> parent;
    public final List<INbtSaveNode> nodes = new LinkedList<INbtSaveNode>();
    private boolean shouldSave = true;

    public NbtSaveRoot(String name, NbtSaveHandler<SaveObject> handler, NbtSaveRoot<SaveObject> parent) {
        if (name == null) {
            throw new IllegalArgumentException("save key can't be null");
        }
        this.name = name;
        this.handler = handler;
        this.parent = parent;
    }

    public NbtSaveRoot<SaveObject> disableSave() {
        this.shouldSave = false;
        return this;
    }

    @Override
    public String getSaveKey() {
        return this.name;
    }

    @Override
    public NBTTagCompound save(SaveObject objectToSave) {
        if (!this.shouldSave) {
            return null;
        }
        return this.save(objectToSave, new NBTTagCompound());
    }

    protected NBTTagCompound save(SaveObject objectToSave, NBTTagCompound tagCompound) {
        this.nodes.forEach(node -> {
            Object tag = node.save(objectToSave);
            if (tag != null && !tag.func_82582_d()) {
                tagCompound.func_74782_a(node.getSaveKey(), tag);
            }
        });
        return tagCompound;
    }

    @Override
    public void load(SaveObject objectToLoad, NBTTagCompound save) {
        if (save != null && !save.func_82582_d()) {
            this.nodes.forEach(node -> {
                if (save.func_74764_b(node.getSaveKey())) {
                    node.load(objectToLoad, save.func_74781_a(node.getSaveKey()));
                }
            });
        }
    }

    public NbtSaveRoot<SaveObject> addRoot(String name) {
        NbtSaveRoot<SaveObject> root = new NbtSaveRoot<SaveObject>(name, this.handler, this);
        this.nodes.add(root);
        return root;
    }

    public <O extends NBTBase> NbtSaveRoot<SaveObject> node(NbtSaveNode<SaveObject, O> node) {
        this.nodes.add(node);
        return this;
    }

    public NbtSaveRoot<SaveObject> nodeString(String name, Function<SaveObject, String> save, BiConsumer<SaveObject, String> load) {
        return this.node(new SaveNodeString<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeResourceLocation(String name, Function<SaveObject, ResourceLocation> save, BiConsumer<SaveObject, ResourceLocation> load) {
        return this.node(new SaveNodeResourceLocation<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeCompoundTag(String name, Function<SaveObject, NBTTagCompound> save, BiConsumer<SaveObject, NBTTagCompound> load) {
        return this.node(new SaveNodeCompoundTag<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeByte(String name, Function<SaveObject, Byte> save, BiConsumer<SaveObject, Byte> load) {
        return this.node(new SaveNodeByte<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeInteger(String name, Function<SaveObject, Integer> save, BiConsumer<SaveObject, Integer> load) {
        return this.node(new SaveNodeInteger<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeDouble(String name, Function<SaveObject, Double> save, BiConsumer<SaveObject, Double> load) {
        return this.node(new SaveNodeDouble<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeFloat(String name, Function<SaveObject, Float> save, BiConsumer<SaveObject, Float> load) {
        return this.node(new SaveNodeFloat<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeBoolean(String name, Function<SaveObject, Boolean> save, BiConsumer<SaveObject, Boolean> load) {
        return this.node(new SaveNodeBoolean<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeBlockPos(String name, Function<SaveObject, BlockPos> save, BiConsumer<SaveObject, BlockPos> load) {
        return this.node(new SaveNodeBlockPos<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeVec3d(String name, Function<SaveObject, Vec3d> save, BiConsumer<SaveObject, Vec3d> load) {
        return this.node(new SaveNodeVec3d<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeWorldDim(String name, Function<SaveObject, World> save, BiConsumer<SaveObject, World> load) {
        return this.node(new NbtSaveNode<Object, NBTTagInt>(name, saveObject -> {
            World world = (World)save.apply(saveObject);
            if (world != null && world.field_73011_w != null) {
                return new NBTTagInt(world.field_73011_w.getDimension());
            }
            return null;
        }, (saveObject, data) -> {
            int dim = data.func_150287_d();
            WorldServer world = DimensionManager.getWorld((int)dim);
            load.accept((Object)saveObject, (World)world);
        }));
    }

    @Deprecated
    public NbtSaveRoot<SaveObject> nodePos(String name, Function<SaveObject, Pos> save, BiConsumer<SaveObject, Pos> load) {
        return this.node(new SaveNodePos<SaveObject>(name, save, load));
    }

    @Deprecated
    public NbtSaveRoot<SaveObject> nodeEulerAngle(String name, Function<SaveObject, EulerAngle> save, BiConsumer<SaveObject, EulerAngle> load) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, saveObject -> {
            EulerAngle angle = (EulerAngle)save.apply(saveObject);
            if (angle != null) {
                return angle.toNBT();
            }
            return null;
        }, (saveObject, data) -> load.accept(saveObject, new EulerAngle((NBTTagCompound)data))));
    }

    public <EnumVal extends Enum<EnumVal>> NbtSaveRoot<SaveObject> nodeEnumString(String name, Function<SaveObject, EnumVal> save, BiConsumer<SaveObject, EnumVal> load, Function<String, EnumVal> accessor) {
        return this.node(new SaveNodeEnum<SaveObject, EnumVal>(name, save, load, accessor));
    }

    @Deprecated
    public NbtSaveRoot<SaveObject> nodeFacing(String name, Function<SaveObject, EnumFacing> save, BiConsumer<SaveObject, EnumFacing> load) {
        return this.node(new SaveNodeFacing<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeBlockState(String name, Function<SaveObject, IBlockState> save, BiConsumer<SaveObject, IBlockState> load) {
        return this.node(new SaveNodeBlockState<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> nodeUUID(String name, Function<SaveObject, UUID> save, BiConsumer<SaveObject, UUID> load) {
        return this.node(new SaveNodeUUID<SaveObject>(name, save, load));
    }

    public <BuildableObject extends IBuildableObject> NbtSaveRoot<SaveObject> nodeBuildableObject(String name, Supplier<IBuilderRegistry<BuildableObject>> reg, Function<SaveObject, BuildableObject> getter, BiConsumer<SaveObject, BuildableObject> setter) {
        return this.node(new SaveBuildableObject(name, reg, getter, setter));
    }

    public <BuildableObject extends IBuildableObject> NbtSaveRoot<SaveObject> nodeBuildableObjectList(String name, Supplier<IBuilderRegistry<BuildableObject>> reg, Function<SaveObject, Collection<BuildableObject>> getter) {
        return this.node(new SaveBuildableObjectList(name, reg, getter));
    }

    public <SerializableObject extends INBTSerializable<NBTTagCompound>> NbtSaveRoot<SaveObject> nodeINBTSerializable(String name, Function<SaveObject, SerializableObject> accessor) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, source -> Optional.ofNullable(accessor.apply(source)).map(INBTSerializable::serializeNBT).orElse(null), (source, data) -> {
            INBTSerializable object = (INBTSerializable)accessor.apply(source);
            if (object != null) {
                object.deserializeNBT((NBTBase)data);
            }
        }));
    }

    public <C extends INBTSerializable<NBTTagCompound>> NbtSaveRoot<SaveObject> nodeINBTSerializable(String name, Function<SaveObject, C> save, BiConsumer<SaveObject, C> load, Supplier<C> builder) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, source -> Optional.ofNullable(save.apply(source)).map(INBTSerializable::serializeNBT).orElse(null), (source, data) -> {
            INBTSerializable object = (INBTSerializable)builder.get();
            if (object != null) {
                object.deserializeNBT((NBTBase)data);
            }
            load.accept(source, object);
        }));
    }

    public NbtSaveRoot<SaveObject> nodeItemStack(String name, Function<SaveObject, ItemStack> save, BiConsumer<SaveObject, ItemStack> load) {
        return this.node(new SaveNodeItemStack<SaveObject>(name, save, load));
    }

    public NbtSaveRoot<SaveObject> parent() {
        return this.parent;
    }

    public NbtSaveHandler<SaveObject> base() {
        return this.handler;
    }
}

