/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.launcher;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CapabilityMissileHolder
implements IMissileHolder {
    private final IItemHandlerModifiable inventory;
    private final int slot;

    public CapabilityMissileHolder(IItemHandlerModifiable inventory, int slot) {
        this.inventory = inventory;
        this.slot = slot;
    }

    @Override
    public ItemStack getMissileStack() {
        return this.inventory.getStackInSlot(this.slot);
    }

    @Override
    public ItemStack insertMissileStack(ItemStack stack, boolean simulate) {
        if (this.canSupportMissile(stack)) {
            return this.inventory.insertItem(this.slot, stack, simulate);
        }
        return null;
    }

    @Override
    public boolean consumeMissile() {
        ICapabilityMissileStack missileStack;
        if (this.hasMissile() && (missileStack = (ICapabilityMissileStack)this.getMissileStack().getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) != null) {
            this.inventory.setStackInSlot(this.slot, missileStack.consumeMissile());
            return true;
        }
        return false;
    }

    @Override
    public boolean canSupportMissile(ItemStack stack) {
        return this.inventory.isItemValid(this.slot, stack);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMissileHolder.class, (Capability.IStorage)new Capability.IStorage<IMissileHolder>(){

            @Nullable
            public NBTBase writeNBT(Capability<IMissileHolder> capability, IMissileHolder instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IMissileHolder> capability, IMissileHolder instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMissileHolder(null, 0));
    }
}

