/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.gps;

import icbm.classic.api.caps.IGPSData;
import icbm.classic.lib.LanguageUtility;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class GPSDataHelpers {
    public static boolean handlePlayerInteraction(IGPSData gpsData, EntityPlayer player, BiConsumer<World, Vec3d> setter) {
        return GPSDataHelpers.handlePlayerInteraction(gpsData, player, true, setter);
    }

    public static boolean handlePlayerInteraction(IGPSData gpsData, EntityPlayer player, Consumer<Vec3d> setter) {
        return GPSDataHelpers.handlePlayerInteraction(gpsData, player, false, (w, v) -> setter.accept((Vec3d)v));
    }

    public static boolean handlePlayerInteraction(IGPSData gpsData, EntityPlayer player, boolean setWorld, BiConsumer<World, Vec3d> setter) {
        if (gpsData == null) {
            return false;
        }
        Vec3d position = gpsData.getPosition();
        World world = gpsData.getWorld();
        if (position == null) {
            player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.noTargetInTool")));
        } else if (setWorld && world != null) {
            setter.accept(world, position);
            String x = String.format("%.1f", position.field_72450_a);
            String y = String.format("%.1f", position.field_72448_b);
            String z = String.format("%.1f", position.field_72449_c);
            String name = Optional.of(world.func_72912_H()).map(WorldInfo::func_76065_j).orElse("--");
            String worldName = String.format("(%s)%s", world.field_73011_w.getDimension(), name);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("info.icbmclassic:gps.set.all", new Object[]{x, y, z, worldName}));
        } else {
            setter.accept(null, gpsData.getPosition());
            String x = String.format("%.1f", position.field_72450_a);
            String y = String.format("%.1f", position.field_72448_b);
            String z = String.format("%.1f", position.field_72449_c);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("info.icbmclassic:gps.set.pos", new Object[]{x, y, z}));
        }
        return true;
    }
}

