/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.buildable;

import icbm.classic.ICBMClassic;
import icbm.classic.api.reg.obj.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BuildableObjectRegistry<Part extends IBuildableObject>
implements IBuilderRegistry<Part> {
    private final Map<ResourceLocation, Supplier<Part>> builders = new HashMap<ResourceLocation, Supplier<Part>>();
    private boolean isLocked = false;
    private final String loggerPrefix;
    private final String key;

    @Deprecated
    public BuildableObjectRegistry(String loggerPrefix) {
        this.loggerPrefix = loggerPrefix;
        this.key = loggerPrefix.toLowerCase(Locale.ROOT).replace("_", ".");
    }

    public BuildableObjectRegistry(String loggerPrefix, String key) {
        this.loggerPrefix = loggerPrefix;
        this.key = key;
    }

    @Override
    public void register(@Nonnull ResourceLocation key, @Nonnull Supplier<Part> builder) {
        if (this.isLocked) {
            throw new RuntimeException(this.loggerPrefix + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        if (this.builders.containsKey(key)) {
            throw new RuntimeException(this.loggerPrefix + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to override '" + key + "'. This method does not allow replacing existing registries. See implementing class for override call.");
        }
        this.builders.put(key, builder);
    }

    public void overrideRegistry(ResourceLocation key, Supplier<Part> builder) {
        if (this.isLocked) {
            throw new RuntimeException(this.loggerPrefix + ":mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        ICBMClassic.logger().info(this.loggerPrefix + ":'" + key + "' is being overridden by " + FMLCommonHandler.instance().getModName());
        this.builders.put(key, builder);
    }

    @Override
    public Part getOrBuild(@Nonnull ResourceLocation name) {
        return (Part)((IBuildableObject)Optional.ofNullable(this.builders.get(name)).map(Supplier::get).orElse(null));
    }

    @Override
    @Nonnull
    public String getUniqueName() {
        return this.key;
    }

    public void lock() {
        this.isLocked = true;
    }

    @Override
    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }
}

