/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions.status;

import icbm.classic.api.actions.status.IActionStatus;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ActionStatus
implements IActionStatus {
    private boolean error = false;
    private boolean block = false;
    protected String translationKey;
    protected ITextComponent textComponent;
    private ResourceLocation regName;

    public ActionStatus asError() {
        this.error = true;
        return this;
    }

    public ActionStatus asBlocking() {
        this.block = true;
        return this;
    }

    public ActionStatus withTranslation(String key) {
        this.translationKey = key;
        return this;
    }

    public ActionStatus withRegName(String key) {
        return this.withRegName("icbmclassic", key);
    }

    public ActionStatus withRegName(String domain, String key) {
        this.regName = new ResourceLocation(domain, key);
        return this;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public boolean isBlocking() {
        return this.isError() || this.block;
    }

    @Override
    public ITextComponent message() {
        if (this.textComponent == null) {
            this.textComponent = new TextComponentTranslation(this.translationKey, new Object[0]);
        }
        return this.textComponent;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return this.regName;
    }

    public String toString() {
        return "ActionStatus[ '" + this.getRegistryKey() + "' , '" + this.translationKey + "' ]@" + this.hashCode();
    }

    @Generated
    public ActionStatus() {
    }
}

