/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions.listners;

import icbm.classic.ICBMClassic;
import icbm.classic.api.actions.IAction;
import icbm.classic.api.actions.listener.IActionListener;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.data.meta.MetaTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ActionListenerLayer {
    private final MetaTag layerTag;
    private final Map<MetaTag, ActionListenerLayer> layers = new HashMap<MetaTag, ActionListenerLayer>();
    private final List<IActionListener> listeners = new ArrayList<IActionListener>();

    public IActionStatus onAction(IAction action) {
        IActionStatus status;
        for (IActionListener listener : this.listeners) {
            status = listener.onAction(action);
            if (status == null) continue;
            return status;
        }
        for (ActionListenerLayer layer : this.layers.values()) {
            if (!action.getActionData().isType(layer.layerTag) || (status = layer.onAction(action)) == null) continue;
            return status;
        }
        return null;
    }

    public void add(IActionListener listener) {
        if (this.listeners.contains(listener)) {
            ICBMClassic.logger().error("ActionListenerLayer({}): listener is already added to this layer. Listener: {}", (Object)this.layerTag, (Object)listener);
            return;
        }
        this.listeners.add(listener);
    }

    public void add(IActionListener listener, MetaTag tag) {
        if (this.listeners.contains(listener)) {
            ICBMClassic.logger().error("ActionListenerLayer({}): listener is already added to this layer. Listener: {}", (Object)this.layerTag, (Object)listener);
            return;
        }
        if (tag == this.layerTag) {
            this.listeners.add(listener);
            return;
        }
        if (tag.getParent() == null || tag.getParent() == this.layerTag) {
            this.layers.computeIfAbsent(tag, k -> new ActionListenerLayer(tag)).add(listener);
            return;
        }
        MetaTag parent = tag.getParent();
        while (parent.getParent() != null && parent.getParent() != this.layerTag) {
            parent = parent.getParent();
        }
        if (!this.layers.containsKey(parent)) {
            this.layers.put(parent, new ActionListenerLayer(parent));
        }
        this.layers.get(parent).add(listener, tag);
    }

    public String toString() {
        return "ActionListenerLayer(" + this.layerTag + ")@" + this.hashCode();
    }

    @Generated
    public ActionListenerLayer(MetaTag layerTag) {
        this.layerTag = layerTag;
    }
}

