/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.datafix;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.refs.ICBMEntities;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogicOld;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import icbm.classic.content.missile.logic.targeting.BallisticTargetingData;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.datafix.DataFixerHelpers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.datafix.IFixableData;

public class EntityMissileDataFixer
implements IFixableData {
    private static final String ENTITY_ID = "id";
    public static final EntityMissileDataFixer INSTANCE = new EntityMissileDataFixer();

    public NBTTagCompound func_188217_a(NBTTagCompound existingSave) {
        int damage;
        NBTTagCompound stackSave;
        if (existingSave.func_74764_b(ENTITY_ID) && existingSave.func_74779_i(ENTITY_ID).equalsIgnoreCase("icbmclassic:missile")) {
            existingSave.func_74778_a(ENTITY_ID, ICBMEntities.MISSILE_EXPLOSIVE.toString());
            this.convertProjectileTags(existingSave);
            this.convertEntityMissileTags(existingSave);
            this.convertExplosiveData(existingSave);
            DataFixerHelpers.removeTags(existingSave, "missileType");
            DataFixerHelpers.removeTags(existingSave, "target", "targetHeight");
            DataFixerHelpers.removeTags(existingSave, "launcherPos");
            DataFixerHelpers.removeTags(existingSave, "acceleration", "lockHeight", "preLaunchSmokeTimer");
            DataFixerHelpers.removeTags(existingSave, "additionalMissileData", "explosiveID");
            DataFixerHelpers.removeTags(existingSave, "sourcePos", "Shooter-UUID");
            DataFixerHelpers.removeTags(existingSave, "xTilePos", "yTilePos", "zTilePos");
            DataFixerHelpers.removeTags(existingSave, "sideTilePos", "inTileState");
            DataFixerHelpers.removeTags(existingSave, "life", "ticksInAir");
        } else if (existingSave.func_74764_b(ENTITY_ID) && existingSave.func_74779_i(ENTITY_ID).equalsIgnoreCase(ICBMEntities.MISSILE_EXPLOSIVE.toString()) && existingSave.func_74764_b("explosive") && (stackSave = existingSave.func_74775_l("explosive_stack")).func_74764_b("Damage") && (damage = stackSave.func_74762_e("Damage")) == ICBMExplosives.HYPERSONIC.getRegistryID()) {
            stackSave.func_74768_a("Damage", ICBMExplosives.SONIC.getRegistryID());
            stackSave.func_82580_o("tag");
            stackSave.func_82580_o("ForgeCaps");
        }
        return existingSave;
    }

    private void convertEntityMissileTags(NBTTagCompound existingSave) {
        int missileType = existingSave.func_74762_e("missileType");
        NBTTagCompound missile = new NBTTagCompound();
        existingSave.func_74782_a("missile", (NBTBase)missile);
        NBTTagCompound missileFlags = new NBTTagCompound();
        missile.func_74782_a("flags", (NBTBase)missileFlags);
        missileFlags.func_74774_a("doFlight", (byte)1);
        this.convertTargetData(existingSave, missile, missileType);
        this.convertFlightLogic(existingSave, missile, missileType);
        this.convertMissileSource(existingSave, missile, missileType);
    }

    private void convertExplosiveData(NBTTagCompound existingSave) {
        int explosiveId = existingSave.func_74762_e("explosiveID");
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(explosiveId);
        ItemStack stack = ICBMClassicAPI.EX_MISSILE_REGISTRY.getDeviceStack(data);
        existingSave.func_74782_a("explosive", (NBTBase)stack.serializeNBT());
    }

    private void convertTargetData(NBTTagCompound existingSave, NBTTagCompound missile, int missileType) {
        if (existingSave.func_74764_b("target")) {
            NBTTagCompound targetData = new NBTTagCompound();
            missile.func_74782_a("target", (NBTBase)targetData);
            NBTTagCompound data = new NBTTagCompound();
            targetData.func_74782_a("data", (NBTBase)data);
            targetData.func_74778_a(ENTITY_ID, missileType == 0 ? BallisticTargetingData.REG_NAME.toString() : BasicTargetData.REG_NAME.toString());
            data.func_74780_a("x", existingSave.func_74775_l("target").func_74769_h("x"));
            data.func_74780_a("y", existingSave.func_74775_l("target").func_74769_h("y"));
            data.func_74780_a("z", existingSave.func_74775_l("target").func_74769_h("z"));
            if (missileType == 0) {
                data.func_74780_a("impact_height", (double)existingSave.func_74762_e("targetHeight"));
            }
        }
    }

    private void convertFlightLogic(NBTTagCompound existingSave, NBTTagCompound missile, int missileType) {
        NBTTagCompound targetData = new NBTTagCompound();
        missile.func_74782_a("flight", (NBTBase)targetData);
        NBTTagCompound data = new NBTTagCompound();
        targetData.func_74782_a("data", (NBTBase)data);
        targetData.func_74778_a(ENTITY_ID, missileType == 0 ? BallisticFlightLogicOld.REG_NAME.toString() : DeadFlightLogic.REG_NAME.toString());
        if (missileType == 0) {
            int preLauncherTime = existingSave.func_74762_e("preLaunchSmokeTimer");
            double lockHeight = existingSave.func_74769_h("lockHeight");
            NBTTagCompound flags = new NBTTagCompound();
            data.func_74782_a("flags", (NBTBase)flags);
            flags.func_74774_a("flight_started", (byte)0);
            NBTTagCompound inputs = new NBTTagCompound();
            data.func_74782_a("inputs", (NBTBase)inputs);
            inputs.func_74780_a("start_x", existingSave.func_150295_c("Pos", 6).func_150309_d(0));
            inputs.func_74780_a("start_y", existingSave.func_150295_c("Pos", 6).func_150309_d(1));
            inputs.func_74780_a("start_z", existingSave.func_150295_c("Pos", 6).func_150309_d(2));
            inputs.func_74780_a("end_x", existingSave.func_74775_l("target").func_74769_h("x"));
            inputs.func_74780_a("end_y", existingSave.func_74775_l("target").func_74769_h("y"));
            inputs.func_74780_a("end_z", existingSave.func_74775_l("target").func_74769_h("z"));
            NBTTagCompound timers = new NBTTagCompound();
            data.func_74782_a("timers", (NBTBase)timers);
            timers.func_74768_a("engine_warm_up", preLauncherTime);
            timers.func_74780_a("lock_height", lockHeight);
        } else if (missileType == 1) {
            data.func_74768_a("fuel", ConfigMissile.CRUISE_FUEL);
        } else if (missileType == 2) {
            data.func_74768_a("fuel", ConfigMissile.HANDHELD_FUEL);
        }
    }

    private void convertMissileSource(NBTTagCompound existingSave, NBTTagCompound missile, int missileType) {
        if (missileType == 0) {
            NBTTagCompound missileSource = new NBTTagCompound();
            missile.func_74782_a("source", (NBTBase)missileSource);
            NBTTagCompound pos = new NBTTagCompound();
            missileSource.func_74782_a("pos", (NBTBase)pos);
            pos.func_74780_a("x", existingSave.func_74775_l("launcherPos").func_74769_h("x"));
            pos.func_74780_a("y", existingSave.func_74775_l("launcherPos").func_74769_h("y"));
            pos.func_74780_a("z", existingSave.func_74775_l("launcherPos").func_74769_h("z"));
        } else if (missileType == 1 || missileType == 2) {
            NBTTagCompound missileSource = new NBTTagCompound();
            missile.func_74782_a("source", (NBTBase)missileSource);
            NBTTagCompound pos = new NBTTagCompound();
            missileSource.func_74782_a("pos", (NBTBase)pos);
            pos.func_74780_a("x", existingSave.func_74775_l("sourcePos").func_74769_h("x"));
            pos.func_74780_a("y", existingSave.func_74775_l("sourcePos").func_74769_h("y"));
            pos.func_74780_a("z", existingSave.func_74775_l("sourcePos").func_74769_h("z"));
        }
    }

    private void convertProjectileTags(NBTTagCompound existingSave) {
        NBTTagCompound flags = new NBTTagCompound();
        existingSave.func_74782_a("flags", (NBTBase)flags);
        flags.func_74774_a("ground", existingSave.func_74771_c("inGround"));
        existingSave.func_82580_o("inGround");
        NBTTagCompound ground = new NBTTagCompound();
        existingSave.func_74782_a("ground", (NBTBase)ground);
        NBTTagCompound tilePos = new NBTTagCompound();
        tilePos.func_74768_a("x", existingSave.func_74762_e("xTilePos"));
        tilePos.func_74768_a("y", existingSave.func_74762_e("yTilePos"));
        tilePos.func_74768_a("z", existingSave.func_74762_e("zTilePos"));
        ground.func_74782_a("pos", (NBTBase)tilePos);
        ground.func_74774_a("side", existingSave.func_74771_c("sideTilePos"));
        int oldBlockState = existingSave.func_74762_e("inTileState");
        IBlockState blockState = Block.func_176220_d((int)oldBlockState);
        ground.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)blockState));
        NBTTagCompound ticks = new NBTTagCompound();
        existingSave.func_74782_a("ticks", (NBTBase)ticks);
        ticks.func_74768_a("air", existingSave.func_74762_e("ticksInAir"));
        ticks.func_74768_a("ground", existingSave.func_74762_e("life"));
    }

    public int func_188216_a() {
        return 2;
    }
}

