/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.prefab;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.api.missiles.parts.IMissileFlightLogicStep;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.config.ConfigDebug;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class FlightLogic
implements IMissileFlightLogic,
IMissileFlightLogicStep,
INBTSerializable<NBTTagCompound> {
    private IMissileFlightLogic nextStep;
    private static final NbtSaveHandler<FlightLogic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBuildableObject("next", () -> ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY, FlightLogic::getNextStep, FlightLogic::setNextStep).base();

    @Override
    public void start(Entity entity, IMissile missile) {
        if (!this.isValid()) {
            ICBMClassic.logger().error(this + ": was not setup correctly. Setting flight logic to next step or null to avoid problems. Issue is likely due to custom properties set into the missile.");
            missile.switchFlightLogic(this.getNextStep());
        }
        if (ConfigDebug.DEBUG_MISSILE_LOGIC) {
            this.dumpInformation(str -> ICBMClassic.logger().info(str));
        }
    }

    protected void dumpInformation(Consumer<String> outputLines) {
        outputLines.accept(this + ": Debug Info");
        outputLines.accept("\tNext: " + this.nextStep);
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        if (this.isDone() && !entity.field_70170_p.field_72995_K) {
            missile.switchFlightLogic(this.getNextStep());
        }
    }

    @Override
    public <V> V predictPosition(Entity entity, IMissileFlightLogic.VecBuilderFunc<V> builder, int ticks) {
        return null;
    }

    @Override
    public boolean shouldDecreaseMotion(Entity entity) {
        return !this.isValid();
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean isDone();

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    @Nonnull
    public IBuilderRegistry<IMissileFlightLogic> getRegistry() {
        return ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY;
    }

    @Override
    @Generated
    public IMissileFlightLogic getNextStep() {
        return this.nextStep;
    }

    @Override
    @Generated
    public FlightLogic setNextStep(IMissileFlightLogic nextStep) {
        this.nextStep = nextStep;
        return this;
    }
}

