/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.prefab;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.FlightLogic;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

public abstract class AccelerateByVec3Logic
extends FlightLogic {
    private Vec3d direction;
    private double acceleration;
    private double velocityAdded = 0.0;
    private static final NbtSaveHandler<AccelerateByVec3Logic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeDouble("acceleration", AccelerateByVec3Logic::getAcceleration, AccelerateByVec3Logic::setAcceleration).nodeVec3d("direction", AccelerateByVec3Logic::getDirection, AccelerateByVec3Logic::setDirection).base();

    @Override
    protected void dumpInformation(Consumer<String> outputLines) {
        super.dumpInformation(outputLines);
        outputLines.accept("\tDirection: " + this.direction);
        outputLines.accept("\tAcceleration: " + this.acceleration);
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (this.isValid() && !this.isDone()) {
            entity.field_70159_w += this.direction.field_72450_a * this.acceleration;
            entity.field_70181_x += this.direction.field_72448_b * this.acceleration;
            entity.field_70179_y += this.direction.field_72449_c * this.acceleration;
            this.velocityAdded += this.acceleration;
        }
    }

    @Override
    public boolean isValid() {
        return this.direction != null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public Vec3d getDirection() {
        return this.direction;
    }

    @Generated
    public AccelerateByVec3Logic setDirection(Vec3d direction) {
        this.direction = direction;
        return this;
    }

    @Generated
    public double getAcceleration() {
        return this.acceleration;
    }

    @Generated
    public AccelerateByVec3Logic setAcceleration(double acceleration) {
        this.acceleration = acceleration;
        return this;
    }

    @Generated
    public double getVelocityAdded() {
        return this.velocityAdded;
    }
}

