/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DirectFlightLogic
extends DeadFlightLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "direct");
    private double motionX;
    private double motionY;
    private double motionZ;

    public DirectFlightLogic() {
    }

    public DirectFlightLogic(int fuelTicks) {
        super(fuelTicks);
    }

    @Override
    public void calculateFlightPath(World world, double startX, double startY, double startZ, IMissileTarget targetData) {
        if (targetData != null) {
            this.motionX = targetData.getX() - startX;
            this.motionY = targetData.getY() - startY;
            this.motionZ = targetData.getZ() - startZ;
            float velocity = MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
            this.motionX /= (double)velocity;
            this.motionY /= (double)velocity;
            this.motionZ /= (double)velocity;
            this.motionX *= (double)ConfigMissile.DIRECT_FLIGHT_SPEED;
            this.motionY *= (double)ConfigMissile.DIRECT_FLIGHT_SPEED;
            this.motionZ *= (double)ConfigMissile.DIRECT_FLIGHT_SPEED;
        }
    }

    @Override
    public void start(Entity entity, IMissile missile) {
        entity.field_70159_w = this.motionX;
        entity.field_70181_x = this.motionY;
        entity.field_70179_y = this.motionZ;
        float f3 = MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        entity.field_70126_B = entity.field_70177_z = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        entity.field_70127_C = entity.field_70125_A = (float)(Math.atan2(this.motionY, f3) * 180.0 / Math.PI);
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof DirectFlightLogic) {
            return super.equals(other) && Math.abs(((DirectFlightLogic)other).motionX - this.motionX) <= 1.0E-4 && Math.abs(((DirectFlightLogic)other).motionY - this.motionY) <= 1.0E-4 && Math.abs(((DirectFlightLogic)other).motionZ - this.motionZ) <= 1.0E-4;
        }
        return false;
    }
}

