/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic;

import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.missile.logic.targeting.BallisticTargetingData;
import net.minecraft.util.math.Vec3d;

public class TargetRangeDet {
    private final EntityExplosiveMissile missile;

    public TargetRangeDet(EntityExplosiveMissile missile) {
        this.missile = missile;
    }

    public void update() {
        if (this.missile.field_70170_p.field_72995_K || this.missile.getMissileCapability().getTargetData() == null) {
            return;
        }
        double offset = 0.0;
        if (this.missile.getMissileCapability().getTargetData() instanceof BallisticTargetingData) {
            offset = ((BallisticTargetingData)this.missile.getMissileCapability().getTargetData()).getImpactHeightOffset();
        } else if (this.missile.explosive.getExplosiveData() == ICBMExplosives.CLUSTER) {
            offset = 10.0;
        }
        if (offset > 0.0) {
            double distance;
            double deltaX = this.missile.getMissileCapability().getTargetData().getX() - this.missile.field_70165_t;
            double deltaY = this.missile.getMissileCapability().getTargetData().getY() - this.missile.field_70163_u;
            double deltaZ = this.missile.getMissileCapability().getTargetData().getZ() - this.missile.field_70161_v;
            if (this.inRange(offset, deltaX) && this.inRange(offset, deltaZ) && (distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) <= offset) {
                this.missile.explosive.doExplosion(this.missile.field_70165_t, this.missile.field_70163_u, this.missile.field_70161_v, new ActionSource(this.missile.field_70170_p, new Vec3d(this.missile.field_70165_t, this.missile.field_70163_u, this.missile.field_70161_v), new EntityCause(this.missile)));
                this.missile.func_70106_y();
            }
        }
    }

    private boolean inRange(double range, double value) {
        return value <= range && value >= -range;
    }
}

