/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.itemstack.item;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.content.missile.entity.itemstack.HeldActionMode;
import icbm.classic.content.missile.entity.itemstack.item.CapabilityHeldItemMissile;
import icbm.classic.content.missile.entity.itemstack.item.HeldItemMissileHandler;
import lombok.Generated;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHeldItemMissile
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack recipeOutput;

    public boolean func_192399_d() {
        return true;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int itemCount = 0;
        boolean hasMissile = false;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            ++itemCount;
            if (slotStack.func_77973_b() == this.recipeOutput.func_77973_b()) {
                if (hasMissile) {
                    return false;
                }
                hasMissile = true;
                continue;
            }
            if (this.isAllowedItem(slotStack)) continue;
            return false;
        }
        return itemCount == 2 && hasMissile;
    }

    private boolean isAllowedItem(ItemStack slotStack) {
        return HeldItemMissileHandler.isAllowed(slotStack);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack missileIn = null;
        ItemStack cargo = null;
        boolean primaryAction = true;
        for (int slot = 0; slot < inv.func_70302_i_() && (cargo == null || missileIn == null); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() == this.recipeOutput.func_77973_b()) {
                missileIn = this.recipeOutput;
                continue;
            }
            cargo = slotStack;
            if (missileIn == null) continue;
            primaryAction = false;
        }
        if (missileIn == null || cargo == null) {
            return null;
        }
        ItemStack missileOut = missileIn.func_77946_l();
        missileOut.func_190920_e(1);
        ICapabilityMissileStack cap = (ICapabilityMissileStack)missileOut.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
        if (cap instanceof CapabilityHeldItemMissile) {
            if (!((CapabilityHeldItemMissile)cap).getHeldItem().func_190926_b()) {
                return null;
            }
            ItemStack insert = cargo.func_77946_l();
            insert.func_190920_e(1);
            ((CapabilityHeldItemMissile)cap).setHeldItem(insert);
            ((CapabilityHeldItemMissile)cap).setActionMode(primaryAction ? HeldActionMode.PRIMARY : HeldActionMode.SECONDARY);
            return missileOut;
        }
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeHeldItemMissile)) {
            return false;
        }
        RecipeHeldItemMissile other = (RecipeHeldItemMissile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemStack this$recipeOutput = this.func_77571_b();
        ItemStack other$recipeOutput = other.func_77571_b();
        return !(this$recipeOutput == null ? other$recipeOutput != null : !this$recipeOutput.equals(other$recipeOutput));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecipeHeldItemMissile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ItemStack $recipeOutput = this.func_77571_b();
        result = result * 59 + ($recipeOutput == null ? 43 : $recipeOutput.hashCode());
        return result;
    }

    @Generated
    public RecipeHeldItemMissile(ItemStack recipeOutput) {
        this.recipeOutput = recipeOutput;
    }

    @Generated
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Generated
    public String toString() {
        return "RecipeHeldItemMissile(recipeOutput=" + this.func_77571_b() + ")";
    }
}

