/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity;

import icbm.classic.api.actions.IAction;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.config.ConfigEMP;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.entity.explosive.EntityMissileActionable;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import net.minecraft.world.World;

public class CapabilityEmpMissile
implements IEMPReceiver {
    final IMissile missile;

    public CapabilityEmpMissile(IMissile missile) {
        this.missile = missile;
    }

    @Override
    public float applyEmpAction(World world, double x, double y, double z, IAction emp_blast, float power, boolean doAction) {
        if (ConfigEMP.missiles.enabled && this.missile.getMissileEntity() != null && this.missile.getMissileEntity().func_70089_S() && doAction) {
            if (world.field_73012_v.nextFloat() <= ConfigEMP.missiles.missileKillChance) {
                this.missile.getMissileEntity().func_70106_y();
                if (world.field_73012_v.nextFloat() <= ConfigEMP.missiles.engineFullBlowChance) {
                    world.func_72876_a(this.missile.getMissileEntity(), x, y, z, ConfigEMP.missiles.engineFullBlowStrength, false);
                }
            } else if (world.field_73012_v.nextFloat() <= ConfigEMP.missiles.engineKillChance) {
                this.missile.setFlightLogic(new DeadFlightLogic(0));
            } else if (world.field_73012_v.nextFloat() <= ConfigEMP.missiles.missileTriggerChance) {
                if (this.missile.getMissileEntity() instanceof EntityExplosiveMissile) {
                    ((EntityExplosiveMissile)this.missile.getMissileEntity()).explosive.doExplosion(x, y, z, emp_blast.getSource());
                } else if (this.missile.getMissileEntity() instanceof EntityMissileActionable) {
                    ((EntityMissileActionable)this.missile.getMissileEntity()).getMainAction().doAction(world, x, y, z, emp_blast.getSource().getCause());
                } else if (this.missile.getMissileEntity() instanceof EntitySurfaceToAirMissile) {
                    world.func_72876_a(this.missile.getMissileEntity(), x, y, z, ConfigEMP.missiles.engineFullBlowStrength, false);
                }
            }
        }
        return power;
    }
}

