/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blocks.explosive.ItemBlockExplosive;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.capability.ex.CapabilityExplosiveStack;
import icbm.classic.prefab.item.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemGrenade
extends ItemBase {
    public static final int MAX_USE_DURATION = 60;

    public ItemGrenade() {
        this.func_77625_d(16);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityExplosiveStack capabilityExplosive = new CapabilityExplosiveStack(stack);
        if (nbt != null) {
            capabilityExplosive.deserializeNBT(nbt);
        }
        return capabilityExplosive;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 60;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (!world.field_72995_K) {
            world.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            float throwEnergy = (float)(this.func_77626_a(itemStack) - timeLeft) / (float)this.func_77626_a(itemStack);
            new EntityGrenade(world).setItemStack(itemStack).setThrower(entityLiving).aimFromThrower().setThrowMotion(throwEnergy).spawn();
            if (!(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
        }
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemstack) {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(itemstack.func_77952_i());
        if (data != null) {
            return "grenade." + data.getRegistryKey();
        }
        return "grenade";
    }

    public String func_77658_a() {
        return "grenade";
    }

    @Override
    protected boolean hasDetailedInfo(ItemStack stack, EntityPlayer player) {
        return true;
    }

    protected void getDetailedInfo(ItemStack stack, EntityPlayer player, List list) {
        ((ItemBlockExplosive)Item.func_150898_a((Block)BlockReg.blockExplosive)).getDetailedInfo(stack, player, list);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (int id : ICBMClassicAPI.EX_GRENADE_REGISTRY.getExplosivesIDs()) {
                list.add((Object)new ItemStack((Item)this, 1, id));
            }
        }
    }
}

