/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.prefab.item.ItemICBMBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemCrafting
extends ItemICBMBase {
    public final String[] subItems;
    public final String oreName;

    public ItemCrafting(String oreName, String ... items) {
        super(oreName);
        this.oreName = oreName;
        this.subItems = items;
        this.func_77627_a(true);
        this.registerOreNames(new String[0]);
    }

    public void registerOreNames(String ... exceptions) {
        for (int i = 0; i < this.subItems.length; ++i) {
            String name = this.subItems[i];
            this.registerOreName(name, i, exceptions);
        }
    }

    protected void registerOreName(String name, int metadata, String ... exceptions) {
        if (exceptions != null) {
            for (String string : exceptions) {
                if (!name.equalsIgnoreCase(string)) continue;
                return;
            }
        }
        String oreName = name.substring(0, 1).toUpperCase() + name.substring(1);
        oreName = this.oreName + oreName;
        OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Item)this, 1, metadata));
    }

    public String func_77667_c(ItemStack stack) {
        String subName = this.getSubItemName(stack.func_77952_i());
        return super.func_77667_c(stack) + (subName != null ? "." + subName : "");
    }

    public String getSubItemName(int index) {
        if (index >= 0 && index < this.subItems.length) {
            return this.subItems[index];
        }
        return null;
    }

    public int getIndexForName(String name) {
        for (int i = 0; i < this.subItems.length; ++i) {
            String s = this.subItems[i];
            if (!s.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getStack(String name) {
        return this.getStack(name, 1);
    }

    public ItemStack getStack(String name, int count) {
        int index = this.getIndexForName(name);
        if (index > 0) {
            return new ItemStack((Item)this, count, index);
        }
        return ItemStack.field_190927_a;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.subItems.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }
}

