/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.flyingblock;

import icbm.classic.lib.saving.NbtSaveHandler;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class BlockCaptureData
implements INBTSerializable<NBTTagCompound> {
    private IBlockState blockState;
    private ItemStack sourceStack;
    private NBTTagCompound tileEntityData;
    private static final NbtSaveHandler<BlockCaptureData> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBlockState("block_state", BlockCaptureData::getBlockState, BlockCaptureData::setBlockState).nodeItemStack("source_stack", BlockCaptureData::getSourceStack, BlockCaptureData::setSourceStack).nodeCompoundTag("block_entity", BlockCaptureData::getTileEntityData, BlockCaptureData::setTileEntityData).base();

    public BlockCaptureData(IBlockState state, ItemStack stack) {
        this.blockState = state;
        this.sourceStack = stack;
    }

    public BlockCaptureData(World world, BlockPos blockPos) {
        this.blockState = world.func_180495_p(blockPos);
        this.sourceStack = this.blockState.func_177230_c().func_185473_a(world, blockPos, this.blockState);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity != null) {
            this.tileEntityData = new NBTTagCompound();
            tileEntity.func_189515_b(this.tileEntityData);
        }
    }

    public IBlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = Blocks.field_150348_b.func_176223_P();
        }
        return this.blockState;
    }

    public ItemStack getSourceStack() {
        if (this.sourceStack == null) {
            this.sourceStack = new ItemStack(Blocks.field_150348_b);
        }
        return this.sourceStack;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public NBTTagCompound getTileEntityData() {
        return this.tileEntityData;
    }

    @Generated
    public void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
    }

    @Generated
    public void setSourceStack(ItemStack sourceStack) {
        this.sourceStack = sourceStack;
    }

    @Generated
    public void setTileEntityData(NBTTagCompound tileEntityData) {
        this.tileEntityData = tileEntityData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCaptureData)) {
            return false;
        }
        BlockCaptureData other = (BlockCaptureData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IBlockState this$blockState = this.getBlockState();
        IBlockState other$blockState = other.getBlockState();
        if (this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState)) {
            return false;
        }
        ItemStack this$sourceStack = this.getSourceStack();
        ItemStack other$sourceStack = other.getSourceStack();
        if (this$sourceStack == null ? other$sourceStack != null : !this$sourceStack.equals(other$sourceStack)) {
            return false;
        }
        NBTTagCompound this$tileEntityData = this.getTileEntityData();
        NBTTagCompound other$tileEntityData = other.getTileEntityData();
        return !(this$tileEntityData == null ? other$tileEntityData != null : !this$tileEntityData.equals(other$tileEntityData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockCaptureData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IBlockState $blockState = this.getBlockState();
        result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
        ItemStack $sourceStack = this.getSourceStack();
        result = result * 59 + ($sourceStack == null ? 43 : $sourceStack.hashCode());
        NBTTagCompound $tileEntityData = this.getTileEntityData();
        result = result * 59 + ($tileEntityData == null ? 43 : $tileEntityData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BlockCaptureData(blockState=" + this.getBlockState() + ", sourceStack=" + this.getSourceStack() + ", tileEntityData=" + this.getTileEntityData() + ")";
    }

    @Generated
    public BlockCaptureData() {
    }
}

