/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.action;

import com.google.common.collect.ImmutableList;
import icbm.classic.api.actions.IAction;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.data.EntityActionTypes;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.data.meta.MetaTag;
import icbm.classic.content.cluster.action.ActionCluster;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.NotImplementedException;

public class ActionDataCluster
implements IActionData,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "entity.cluster.spawning");
    private static final ImmutableList<MetaTag> TAGS = ImmutableList.of((Object)EntityActionTypes.ENTITY_CREATION);
    private final NonNullList<ItemStack> clusterSpawnEntries = NonNullList.func_191196_a();

    @Override
    @Nonnull
    public IAction create(World world, double x, double y, double z, @Nonnull IActionSource source, @Nullable IActionFieldProvider fieldAccessor) {
        Entity host;
        ActionCluster cluster = new ActionCluster(world, new Vec3d(x, y, z), source, this);
        cluster.setSpawnList(this.clusterSpawnEntries);
        if (fieldAccessor != null && fieldAccessor.hasField(ActionFields.HOST_ENTITY) && (host = fieldAccessor.getValue(ActionFields.HOST_ENTITY)) != null) {
            cluster.setSourcePitch(host.field_70125_A);
            cluster.setSourceYaw(host.field_70177_z);
        }
        return cluster;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    @Nonnull
    public Collection<MetaTag> getTypeTags() {
        return TAGS;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound save = new NBTTagCompound();
        NBTTagList spawnEntries = new NBTTagList();
        for (ItemStack stack : this.clusterSpawnEntries) {
            spawnEntries.func_74742_a((NBTBase)stack.serializeNBT());
        }
        save.func_74782_a("clusterSpawnEntries", (NBTBase)spawnEntries);
        return save;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("clusterSpawnEntries", 10);
        this.clusterSpawnEntries.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(tagList.func_150305_b(i));
            this.clusterSpawnEntries.add((Object)stack);
        }
    }

    @Override
    public void register() {
        throw new NotImplementedException("Cluster is dynamic and doesn't register static");
    }

    @Generated
    public NonNullList<ItemStack> getClusterSpawnEntries() {
        return this.clusterSpawnEntries;
    }
}

