/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cargo.parachute;

import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityParachute
extends EntityProjectile<EntityParachute>
implements IEntityAdditionalSpawnData {
    public static final float GRAVITY = 0.01f;
    public static final float AIR_RESISTANCE = 0.95f;
    public static final float ENTITY_SIZE = 0.5f;
    @Nonnull
    private ItemStack renderItemStack = new ItemStack((Item)ItemReg.itemParachute);
    @Nonnull
    private ItemStack dropItemStack = new ItemStack((Item)ItemReg.itemParachute);
    private float renderScale = 1.0f;
    private float prevRenderScale = 1.0f;
    private static final NbtSaveHandler<EntityParachute> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeItemStack("renderItem", e -> e.renderItemStack, (e, i) -> {
        e.renderItemStack = i;
    }).nodeItemStack("dropItem", e -> e.dropItemStack, (e, i) -> {
        e.dropItemStack = i;
    }).base();

    public EntityParachute(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70156_m = true;
        this.field_70158_ak = true;
    }

    protected void setRenderScale(float scale) {
        this.renderScale = scale;
        if ((double)Math.abs(this.prevRenderScale - scale) > 0.01) {
            this.prevRenderScale = this.renderScale;
            this.func_70105_a(0.5f * scale, 0.5f * scale);
        }
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        return 0.0f;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.ticksInAir);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.renderItemStack);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        this.ticksInAir = data.readInt();
        this.renderItemStack = ByteBufUtils.readItemStack((ByteBuf)data);
    }

    @Override
    protected boolean shouldExpire() {
        return this.ticksInAir >= this.inAirKillTime || this.func_184188_bt().isEmpty();
    }

    public double func_70042_X() {
        return -0.25;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().isEmpty();
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        this.setRenderScale(1.0f);
    }

    public void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (passenger instanceof EntityItem) {
            this.setRenderScale(1.0f);
        } else if (passenger instanceof EntityFlyingBlock) {
            this.setRenderScale(2.0f);
        } else {
            this.setRenderScale(2.0f);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger instanceof EntityItem) {
                if (((EntityItem)passenger).func_92059_d().func_77973_b() instanceof ItemBlock) {
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 0.6, this.field_70161_v);
                } else {
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 0.7, this.field_70161_v);
                }
            } else if (passenger instanceof EntityFlyingBlock) {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 1.5, this.field_70161_v);
            } else {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)passenger.field_70131_O - 0.25, this.field_70161_v);
            }
        }
    }

    @Override
    protected float getGravity() {
        return 0.01f;
    }

    @Override
    protected float getAirResistance() {
        return 0.95f;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected boolean ignoreImpact(RayTraceResult hit) {
        return hit.field_72308_g != null;
    }

    @Override
    protected boolean shouldCollideWith(Entity entity) {
        return super.shouldCollideWith(entity) && entity != this.shootingEntity;
    }

    @Override
    protected void onImpact(RayTraceResult impactLocation) {
        this.releaseParachute();
    }

    @Override
    protected void destroy() {
        this.releaseParachute();
    }

    protected void releaseParachute() {
        this.func_184226_ay();
        this.func_70106_y();
        if (this.isServer() && this.dropItemStack != null && !this.dropItemStack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.dropItemStack.func_77946_l());
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        SAVE_LOGIC.load(this, tag);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        SAVE_LOGIC.save(this, tag);
    }

    @Generated
    public EntityParachute setRenderItemStack(@Nonnull ItemStack renderItemStack) {
        if (renderItemStack == null) {
            throw new NullPointerException("renderItemStack is marked non-null but is null");
        }
        this.renderItemStack = renderItemStack;
        return this;
    }

    @Nonnull
    @Generated
    public ItemStack getRenderItemStack() {
        return this.renderItemStack;
    }

    @Generated
    public EntityParachute setDropItemStack(@Nonnull ItemStack dropItemStack) {
        if (dropItemStack == null) {
            throw new NullPointerException("dropItemStack is marked non-null but is null");
        }
        this.dropItemStack = dropItemStack;
        return this;
    }

    @Nonnull
    @Generated
    public ItemStack getDropItemStack() {
        return this.dropItemStack;
    }

    @Generated
    public float getRenderScale() {
        return this.renderScale;
    }
}

