/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cargo;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.projectile.IProjectileStack;
import icbm.classic.content.cargo.CargoHolderHandler;
import icbm.classic.content.cargo.CargoProjectileData;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.projectile.ProjectileStack;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeCargoData
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack recipeOutput;
    private final Supplier<CargoProjectileData> dataBuilder;

    public boolean func_192399_d() {
        return true;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int itemCount = 0;
        boolean hasCargoItem = false;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            ++itemCount;
            if (ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)this.recipeOutput)) {
                hasCargoItem = this.isValidProjectileStack(this.getProjectileStack(slotStack));
                continue;
            }
            if (!(slotStack.func_77973_b() != ItemReg.itemClusterMissile && slotStack.func_77973_b() != ItemReg.heldItemMissile || hasCargoItem)) {
                return false;
            }
            if (CargoHolderHandler.isAllowed(slotStack)) continue;
            return false;
        }
        return itemCount == 2 && hasCargoItem;
    }

    private ProjectileStack getProjectileStack(ItemStack stack) {
        if (!stack.hasCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null)) {
            return null;
        }
        IProjectileStack iProjectileStack = (IProjectileStack)stack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null);
        if (iProjectileStack instanceof ProjectileStack) {
            return (ProjectileStack)iProjectileStack;
        }
        return null;
    }

    private boolean isValidProjectileStack(IProjectileStack projectileStack) {
        return projectileStack != null && (projectileStack.getProjectileData() == null || projectileStack.getProjectileData() instanceof CargoProjectileData);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack cargoHolder = null;
        ItemStack cargo = null;
        for (int slot = 0; slot < inv.func_70302_i_() && (cargo == null || cargoHolder == null); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            if (ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)this.recipeOutput)) {
                ProjectileStack projectileStack = this.getProjectileStack(slotStack);
                if (cargoHolder == null && this.isValidProjectileStack(projectileStack)) {
                    cargoHolder = slotStack;
                    continue;
                }
                cargo = slotStack;
                continue;
            }
            cargo = slotStack;
        }
        if (cargoHolder == null || cargo == null) {
            return null;
        }
        ItemStack output = cargoHolder.func_77946_l();
        output.func_190920_e(1);
        ProjectileStack projectileStack = this.getProjectileStack(output);
        CargoProjectileData projectileData = projectileStack.getProjectileData() instanceof CargoProjectileData ? (CargoProjectileData)projectileStack.getProjectileData() : this.dataBuilder.get();
        ItemStack insert = cargo.func_77946_l();
        insert.func_190920_e(1);
        projectileData.setHeldItem(insert);
        projectileStack.setProjectileData(projectileData);
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeCargoData)) {
            return false;
        }
        RecipeCargoData other = (RecipeCargoData)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemStack this$recipeOutput = this.func_77571_b();
        ItemStack other$recipeOutput = other.func_77571_b();
        if (this$recipeOutput == null ? other$recipeOutput != null : !this$recipeOutput.equals(other$recipeOutput)) {
            return false;
        }
        Supplier<CargoProjectileData> this$dataBuilder = this.getDataBuilder();
        Supplier<CargoProjectileData> other$dataBuilder = other.getDataBuilder();
        return !(this$dataBuilder == null ? other$dataBuilder != null : !this$dataBuilder.equals(other$dataBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecipeCargoData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ItemStack $recipeOutput = this.func_77571_b();
        result = result * 59 + ($recipeOutput == null ? 43 : $recipeOutput.hashCode());
        Supplier<CargoProjectileData> $dataBuilder = this.getDataBuilder();
        result = result * 59 + ($dataBuilder == null ? 43 : $dataBuilder.hashCode());
        return result;
    }

    @Generated
    public RecipeCargoData(ItemStack recipeOutput, Supplier<CargoProjectileData> dataBuilder) {
        this.recipeOutput = recipeOutput;
        this.dataBuilder = dataBuilder;
    }

    @Generated
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Generated
    public Supplier<CargoProjectileData> getDataBuilder() {
        return this.dataBuilder;
    }

    @Generated
    public String toString() {
        return "RecipeCargoData(recipeOutput=" + this.func_77571_b() + ", dataBuilder=" + this.getDataBuilder() + ")";
    }
}

