/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.missiles.parts.IMissileTargetDelayed;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.tile.ITick;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FiringPackage
implements INBTSerializable<NBTTagCompound>,
ITick {
    private IMissileTarget targetData;
    private IActionCause cause;
    private int countDown = -1;
    private boolean hasFired = false;
    private Consumer<IActionStatus> onTriggerCallback;
    private static final NbtSaveHandler<FiringPackage> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("countdown", FiringPackage::getCountDown, FiringPackage::setCountDown).nodeBuildableObject("target", () -> ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY, FiringPackage::getTargetData, FiringPackage::setTargetData).nodeBuildableObject("cause", () -> ICBMClassicAPI.ACTION_CAUSE_REGISTRY, FiringPackage::getCause, FiringPackage::setCause).base();

    public FiringPackage(IMissileTarget targetData, IActionCause cause, int countDown) {
        this.targetData = targetData;
        this.cause = cause;
        this.countDown = countDown;
    }

    public FiringPackage(IMissileTarget targetData, IActionCause cause) {
        this.targetData = targetData;
        this.cause = cause;
    }

    public void launch(IMissileLauncher missileLauncher) {
        if (!this.hasFired) {
            this.hasFired = true;
            if (this.targetData instanceof IMissileTargetDelayed) {
                this.targetData = ((IMissileTargetDelayed)this.targetData).cloneWithoutDelay();
            }
            IActionStatus status = missileLauncher.launch(launcher -> this.targetData, this.cause, false);
            if (this.onTriggerCallback != null) {
                this.onTriggerCallback.accept(status);
            }
        }
    }

    public boolean isReady() {
        return !this.hasFired;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void update(int tick, boolean isServer) {
        if (isServer && !this.hasFired) {
            --this.countDown;
            if (this.countDown <= 0) {
                // empty if block
            }
        }
    }

    @Generated
    public IMissileTarget getTargetData() {
        return this.targetData;
    }

    @Generated
    public IActionCause getCause() {
        return this.cause;
    }

    @Generated
    public int getCountDown() {
        return this.countDown;
    }

    @Generated
    public boolean isHasFired() {
        return this.hasFired;
    }

    @Generated
    public Consumer<IActionStatus> getOnTriggerCallback() {
        return this.onTriggerCallback;
    }

    @Generated
    public void setTargetData(IMissileTarget targetData) {
        this.targetData = targetData;
    }

    @Generated
    public void setCause(IActionCause cause) {
        this.cause = cause;
    }

    @Generated
    public void setCountDown(int countDown) {
        this.countDown = countDown;
    }

    @Generated
    public void setHasFired(boolean hasFired) {
        this.hasFired = hasFired;
    }

    @Generated
    public void setOnTriggerCallback(Consumer<IActionStatus> onTriggerCallback) {
        this.onTriggerCallback = onTriggerCallback;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiringPackage)) {
            return false;
        }
        FiringPackage other = (FiringPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountDown() != other.getCountDown()) {
            return false;
        }
        if (this.isHasFired() != other.isHasFired()) {
            return false;
        }
        IMissileTarget this$targetData = this.getTargetData();
        IMissileTarget other$targetData = other.getTargetData();
        if (this$targetData == null ? other$targetData != null : !this$targetData.equals(other$targetData)) {
            return false;
        }
        IActionCause this$cause = this.getCause();
        IActionCause other$cause = other.getCause();
        if (this$cause == null ? other$cause != null : !this$cause.equals(other$cause)) {
            return false;
        }
        Consumer<IActionStatus> this$onTriggerCallback = this.getOnTriggerCallback();
        Consumer<IActionStatus> other$onTriggerCallback = other.getOnTriggerCallback();
        return !(this$onTriggerCallback == null ? other$onTriggerCallback != null : !this$onTriggerCallback.equals(other$onTriggerCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiringPackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCountDown();
        result = result * 59 + (this.isHasFired() ? 79 : 97);
        IMissileTarget $targetData = this.getTargetData();
        result = result * 59 + ($targetData == null ? 43 : $targetData.hashCode());
        IActionCause $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : $cause.hashCode());
        Consumer<IActionStatus> $onTriggerCallback = this.getOnTriggerCallback();
        result = result * 59 + ($onTriggerCallback == null ? 43 : $onTriggerCallback.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiringPackage(targetData=" + this.getTargetData() + ", cause=" + this.getCause() + ", countDown=" + this.getCountDown() + ", hasFired=" + this.isHasFired() + ", onTriggerCallback=" + this.getOnTriggerCallback() + ")";
    }
}

