/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.threaded;

import icbm.classic.ICBMClassic;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.blast.BlastRadioactiveBlockSwaps;
import icbm.classic.content.blast.threaded.BlastThreaded;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;

public class BlastNuclear
extends BlastThreaded {
    private double energy;

    public BlastNuclear setEnergy(double energy) {
        this.energy = energy;
        return this;
    }

    @Override
    public boolean doRun(int loops, Consumer<BlockPos> edits) {
        int steps = (int)Math.ceil(Math.PI * (double)this.getBlastRadius());
        int lineDensityScale = 2;
        for (int yawSlices = 0; yawSlices < 2 * steps; ++yawSlices) {
            for (int pitchSlice = 0; pitchSlice < steps; ++pitchSlice) {
                double power = this.energy - this.energy * (double)this.field_77287_j.field_73012_v.nextFloat() / 2.0;
                double yaw = Math.PI / (double)steps * (double)yawSlices;
                double pitch = Math.PI / (double)steps * (double)pitchSlice;
                double dx = Math.sin(pitch) * Math.cos(yaw) * 0.5;
                double dy = Math.cos(pitch) * 0.5;
                double dz = Math.sin(pitch) * Math.sin(yaw) * 0.5;
                double x = this.x();
                double y = this.y();
                double z = this.z();
                BlockPos prevPos = null;
                while (this.location.distance(x, y, z) <= (double)this.getBlastRadius() && power > 0.0) {
                    power -= 1.125;
                    BlockPos blockPos = new BlockPos(Math.floor(x), Math.floor(y), Math.floor(z));
                    if (!Objects.equals(prevPos, blockPos)) {
                        if (!this.field_77287_j.func_175667_e(blockPos)) continue;
                        IBlockState state = this.field_77287_j.func_180495_p(blockPos);
                        Block block = state.func_177230_c();
                        if (!block.isAir(state, (IBlockAccess)this.field_77287_j, blockPos)) {
                            power -= (double)this.getResistance(blockPos, state);
                            if (state.func_185887_b(this.field_77287_j, blockPos) >= 0.0f && power > 0.0) {
                                edits.accept(blockPos);
                            }
                        }
                    }
                    prevPos = blockPos;
                    x += dx;
                    y += dy;
                    z += dz;
                }
            }
        }
        return false;
    }

    public float getResistance(BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (state.func_185904_a().func_76224_d()) {
            return 0.25f;
        }
        return block.getExplosionResistance(this.field_77287_j, pos, (Entity)this.func_94613_c(), (Explosion)this);
    }

    @Override
    public boolean setupBlast() {
        super.setupBlast();
        if (this.world() != null) {
            for (int y = 0; y < 26; ++y) {
                int r = 4;
                if (y < 8) {
                    r = Math.max(Math.min((8 - y) * 2, 10), 4);
                } else if (y > 15) {
                    r = Math.max(Math.min((y - 15) * 2, 15), 5);
                }
                for (int x = -r; x < r; ++x) {
                    for (int z = -r; z < r; ++z) {
                        double distance = MathHelper.func_76129_c((float)(x * x + z * z));
                        if (!((double)r > distance) || !((double)(r - 3) < distance)) continue;
                        Location spawnPosition = (Location)this.location.add(new Pos(x * 2, (y - 2) * 2, z * 2));
                        float xDiff = (float)(spawnPosition.x() - this.location.x());
                        float zDiff = (float)(spawnPosition.z() - this.location.z());
                        this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, spawnPosition.x(), spawnPosition.y(), spawnPosition.z(), (double)xDiff * 0.3 * (double)this.world().field_73012_v.nextFloat(), (double)(-this.world().field_73012_v.nextFloat()), (double)zDiff * 0.3 * (double)this.world().field_73012_v.nextFloat(), new int[0]);
                    }
                }
            }
            this.doDamageEntities((float)ConfigBlast.nuclear.entityDamageScale, (float)(this.energy * ConfigBlast.nuclear.entityDamageMultiplier));
            ICBMSounds.EXPLOSION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        return true;
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        int r = this.callCount;
        if (this.world().field_72995_K) {
            for (int x = -r; x < r; ++x) {
                for (int z = -r; z < r; ++z) {
                    double distance = MathHelper.func_76129_c((float)(x * x + z * z));
                    if (!(distance < (double)r) || !(distance > (double)(r - 1))) continue;
                    Location targetPosition = (Location)this.location.add(new Pos(x, 0.0, z));
                    if (!((double)this.world().field_73012_v.nextFloat() < Math.max(0.001 * (double)r, 0.05))) continue;
                    this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, targetPosition.x(), targetPosition.y(), targetPosition.z(), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        return false;
    }

    @Override
    public void onBlastCompleted() {
        super.onBlastCompleted();
        if (this.world() != null && !this.world().field_72995_K) {
            try {
                this.doDamageEntities((float)ConfigBlast.nuclear.entityDamageScale, (float)(this.energy * ConfigBlast.nuclear.entityDamageMultiplier));
                new BlastRadioactiveBlockSwaps().setBlastWorld(this.world()).setBlastSource(this.field_77283_e).setBlastPosition(this.location.x(), this.location.y(), this.location.z()).setBlastSize((float)ConfigBlast.nuclear.rotScale).setExplosiveData(ICBMExplosives.ROT).buildBlast().doAction();
                new BlastMutation().setBlastWorld(this.world()).setBlastSource(this.field_77283_e).setBlastPosition(this.location.x(), this.location.y(), this.location.z()).setBlastSize((float)ConfigBlast.nuclear.mutationScale).setExplosiveData(ICBMExplosives.MUTATION).buildBlast().doAction();
                ICBMSounds.EXPLOSION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 10.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
            }
            catch (Exception e) {
                String msg = String.format("BlastNuclear#doPostExplode() ->  Unexpected error while running post detonation code \nWorld = %s \nThread = %s\nSize = %s\nPos = %s", this.field_77287_j, this.getThread(), Float.valueOf(this.field_77280_f), this.location);
                ICBMClassic.logger().error(msg, (Throwable)e);
            }
        }
    }
}

