/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.redmatter;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.redmatter.caps.BlastRedmatterWrapper;
import icbm.classic.content.blast.redmatter.caps.CapRedmatterPull;
import icbm.classic.content.blast.redmatter.logic.RedmatterLogic;
import icbm.classic.content.blast.redmatter.render.RedmatterClientLogic;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityRedmatter
extends Entity {
    public static final String NBT_BLAST_SIZE = "blast_size";
    public static final String NBT_BLAST_SIZE_MAX = "blast_size_max";
    public static final float MAX_SPEED = 0.5f;
    public static final float SPEED_REDUCTION = 0.98f;
    public final BlastRedmatterWrapper blastData = new BlastRedmatterWrapper(this);
    public final CapRedmatterPull capRedmatterPull = new CapRedmatterPull(this);
    public final RedmatterClientLogic clientLogic = new RedmatterClientLogic(this);
    public final RedmatterLogic redmatterLogic = new RedmatterLogic(this);
    private static final DataParameter<Float> SIZE_DATA = EntityDataManager.func_187226_a(EntityRedmatter.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_SIZE_DATA = EntityDataManager.func_187226_a(EntityRedmatter.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityRedmatter(World world) {
        super(world);
        this.func_70105_a(0.98f, 0.98f);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70173_aa = 0;
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE_DATA, (Object)Float.valueOf(ConfigBlast.redmatter.DEFAULT_SIZE));
        this.field_70180_af.func_187214_a(MAX_SIZE_DATA, (Object)Float.valueOf(ConfigBlast.redmatter.MAX_SIZE));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
            this.reduceMotion();
            this.correctMotion();
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.redmatterLogic.tick();
        }
    }

    private void reduceMotion() {
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
    }

    private void correctMotion() {
        float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w /= (double)speed;
        this.field_70181_x /= (double)speed;
        this.field_70179_y /= (double)speed;
        float limitedSpeed = Math.min(speed, 0.5f);
        this.field_70159_w *= (double)limitedSpeed;
        this.field_70181_x *= (double)limitedSpeed;
        this.field_70179_y *= (double)limitedSpeed;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(NBT_BLAST_SIZE)) {
            this.setBlastSize(nbt.func_74760_g(NBT_BLAST_SIZE));
        }
        if (nbt.func_74764_b(NBT_BLAST_SIZE_MAX)) {
            this.setBlastSize(nbt.func_74760_g(NBT_BLAST_SIZE_MAX));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74776_a(NBT_BLAST_SIZE, this.getBlastSize());
        nbt.func_74776_a(NBT_BLAST_SIZE_MAX, this.getBlastMaxSize());
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.BLAST_CAPABILITY || capability == ICBMClassicAPI.BLAST_VELOCITY_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.BLAST_CAPABILITY) {
            return (T)ICBMClassicAPI.BLAST_CAPABILITY.cast((Object)this.blastData);
        }
        if (capability == ICBMClassicAPI.BLAST_VELOCITY_CAPABILITY) {
            return (T)ICBMClassicAPI.BLAST_VELOCITY_CAPABILITY.cast((Object)this.capRedmatterPull);
        }
        return (T)super.getCapability(capability, facing);
    }

    public float getBlastSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_DATA)).floatValue();
    }

    public float getBlastMaxSize() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SIZE_DATA)).floatValue();
    }

    public void setBlastSize(float size) {
        float limitedSize = Math.max(ConfigBlast.redmatter.MIN_SIZE, size);
        this.field_70180_af.func_187227_b(SIZE_DATA, (Object)Float.valueOf(limitedSize));
    }

    public void setBlastMaxSize(float size) {
        this.field_70180_af.func_187227_b(MAX_SIZE_DATA, (Object)Float.valueOf(size));
    }
}

