/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions.entity;

import com.google.common.collect.ImmutableList;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.data.ActionField;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.ActionBase;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.actions.status.MissingFieldStatus;
import icbm.classic.lib.projectile.EntityProjectile;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ActionSpawnEntity
extends ActionBase {
    public static final List<ActionField> FIELDS = ImmutableList.of(ActionFields.YAW, ActionFields.PITCH, ActionFields.MOTION_VECTOR, ActionFields.ENTITY_REG_NAME, ActionFields.ENTITY_DATA);
    private ResourceLocation entityID;
    private NBTTagCompound entityData;
    private Vec3d motion;
    private Float yaw;
    private Float pitch;

    public ActionSpawnEntity(World world, Vec3d position, IActionSource source, IActionData actionData) {
        super(world, position, source, actionData);
    }

    @Override
    @Nonnull
    public IActionStatus doAction() {
        if (this.entityID == null) {
            return new MissingFieldStatus().setSource("ActionSpawnEntity").setField("entityId");
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityID, (World)this.getWorld());
        if (entity == null) {
            return new MissingFieldStatus().setSource("ActionSpawnEntity#doAction()").setField("entityInstance");
        }
        entity.func_70107_b(this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c);
        if (this.motion != null) {
            if (entity instanceof EntityProjectile) {
                ((EntityProjectile)entity).setMotionVector(this.motion.field_72450_a, this.motion.field_72448_b, this.motion.field_72449_c);
            } else {
                entity.field_70159_w = this.motion.field_72450_a;
                entity.field_70181_x = this.motion.field_72448_b;
                entity.field_70179_y = this.motion.field_72449_c;
            }
        }
        entity.field_70177_z = this.yaw != null ? (entity.field_70126_B = this.yaw.floatValue()) : (entity.field_70126_B = MathHelper.func_76142_g((float)(this.getWorld().field_73012_v.nextFloat() * 360.0f)));
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70759_as = entity.field_70177_z;
            ((EntityLivingBase)entity).field_70761_aq = entity.field_70177_z;
        }
        if (this.pitch != null) {
            entity.field_70125_A = entity.field_70127_C = this.pitch.floatValue();
        } else {
            entity.field_70177_z = entity.field_70126_B = MathHelper.func_76142_g((float)(this.getWorld().field_73012_v.nextFloat() * 360.0f));
        }
        if (this.entityData != null) {
            UUID uuid = entity.func_110124_au();
            NBTTagCompound mergedData = entity.func_189511_e(new NBTTagCompound());
            mergedData.func_179237_a(this.entityData);
            entity.func_70020_e(mergedData);
            entity.func_184221_a(uuid);
        }
        if (!this.getWorld().func_72838_d(entity)) {
            return ActionResponses.ENTITY_SPAWN_FAILED;
        }
        return ActionResponses.COMPLETED;
    }

    @Override
    public <VALUE, TAG extends NBTBase> void setValue(ActionField<VALUE, TAG> key, VALUE value) {
        if (key == ActionFields.YAW) {
            this.yaw = ActionFields.YAW.cast(value);
        }
        if (key == ActionFields.PITCH) {
            this.pitch = ActionFields.PITCH.cast(value);
        }
        if (key == ActionFields.MOTION_VECTOR) {
            this.motion = (Vec3d)value;
        }
        if (key == ActionFields.ENTITY_REG_NAME) {
            this.entityID = (ResourceLocation)value;
        }
        if (key == ActionFields.ENTITY_DATA) {
            this.entityData = (NBTTagCompound)value;
        }
    }

    @Override
    public <VALUE, TAG extends NBTBase> VALUE getValue(ActionField<VALUE, TAG> key) {
        if (key == ActionFields.YAW) {
            return key.cast(this.yaw);
        }
        if (key == ActionFields.PITCH) {
            return key.cast(this.pitch);
        }
        if (key == ActionFields.MOTION_VECTOR) {
            return key.cast(this.motion);
        }
        if (key == ActionFields.ENTITY_REG_NAME) {
            return key.cast(this.entityID);
        }
        if (key == ActionFields.ENTITY_DATA) {
            return key.cast(this.entityData);
        }
        return null;
    }

    @Override
    public Collection<ActionField> getFields() {
        return FIELDS;
    }
}

