/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions.conditionals;

import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.conditions.ICondition;
import icbm.classic.api.actions.conditions.IConditionCause;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.actions.status.MissingFieldStatus;
import icbm.classic.lib.saving.NbtSaveHandler;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;

public class ConditionTargetDistance
implements ICondition,
IConditionCause,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "projectile.target.distance");
    private IActionFieldProvider provider;
    private double triggerDistance = 10.0;
    private boolean inverted = false;
    private double currentDistance = Double.MIN_VALUE;
    private static final NbtSaveHandler<ConditionTargetDistance> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeDouble("trigger_distance", ConditionTargetDistance::getTriggerDistance, ConditionTargetDistance::setTriggerDistance).nodeBoolean("invert", ConditionTargetDistance::isInverted, ConditionTargetDistance::setInverted).base();

    @Override
    public void init(IActionFieldProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onTick() {
        if (this.provider.hasField(ActionFields.TARGET_POSITION) && this.provider.hasField(ActionFields.HOST_POSITION)) {
            Vec3d value = this.provider.getValue(ActionFields.TARGET_POSITION);
            Vec3d host = this.provider.getValue(ActionFields.HOST_POSITION);
            if (value != null && host != null) {
                this.currentDistance = host.func_72438_d(value);
            }
        }
    }

    @Override
    public IActionStatus getCondition() {
        if (this.provider == null) {
            return new MissingFieldStatus().setSource("ConditionalImpact").setField("provider");
        }
        if (!this.provider.hasField(ActionFields.TARGET_POSITION)) {
            return new MissingFieldStatus().setSource("ConditionalImpact#provider").setField(ActionFields.TARGET_POSITION.getKey());
        }
        if (!this.provider.hasField(ActionFields.HOST_POSITION)) {
            return new MissingFieldStatus().setSource("ConditionalImpact#provider").setField(ActionFields.HOST_POSITION.getKey());
        }
        if (!this.inverted && this.currentDistance >= this.triggerDistance || this.inverted && this.currentDistance <= this.triggerDistance) {
            return ActionResponses.WAITING;
        }
        return ActionResponses.READY;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public IActionCause getCause() {
        return null;
    }

    @Generated
    public double getTriggerDistance() {
        return this.triggerDistance;
    }

    @Generated
    public ConditionTargetDistance setTriggerDistance(double triggerDistance) {
        this.triggerDistance = triggerDistance;
        return this;
    }

    @Generated
    public boolean isInverted() {
        return this.inverted;
    }

    @Generated
    public ConditionTargetDistance setInverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }
}

