/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.util;

import icbm.classic.ICBMClassic;
import icbm.classic.config.util.ResourceConfigEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ResourceConfigList<CONFIG extends ResourceConfigList, CONTENT, VALUE> {
    protected static final Pattern SORTING_REGEX = Pattern.compile("^@sort\\((\\d*),(\\S*)\\)$");
    protected static final Pattern DOMAIN_VALE_REGEX = Pattern.compile("^@domain:([^=]*)(?:=(\\S))?$");
    protected static final Pattern KEY_VALUE_REGEX = Pattern.compile("^([^\\s@]*):([^\\s=]*)(?:=(\\S*))?");
    protected static final Pattern META_KEY_REGEX = Pattern.compile("^([^\\s@]*):([^\\s=@]*)@([0-9]+)(?:=(\\S*))?");
    private final String name;
    private final String configUrl;
    private final Consumer<CONFIG> reloadCallback;
    protected final List<Pair<Pattern, MatcherHandler<CONTENT, VALUE>>> matcherHandlers = new ArrayList<Pair<Pattern, MatcherHandler<CONTENT, VALUE>>>();
    protected final Map<ResourceLocation, List<ResourceConfigEntry<CONTENT, VALUE>>> contentMatchers = new HashMap<ResourceLocation, List<ResourceConfigEntry<CONTENT, VALUE>>>();
    protected final Map<ResourceLocation, List<ResourceConfigEntry<CONTENT, VALUE>>> defaultMatchers = new HashMap<ResourceLocation, List<ResourceConfigEntry<CONTENT, VALUE>>>();
    protected final List<ResourceConfigEntry<CONTENT, VALUE>> generalMatchers = new ArrayList<ResourceConfigEntry<CONTENT, VALUE>>();
    private final Map<String, Map<String, List<Pair<String, Boolean>>>> parsingIssues = new HashMap<String, Map<String, List<Pair<String, Boolean>>>>();
    private boolean isLocked = false;

    public ResourceConfigList(String name, String configUrl, Consumer<CONFIG> reloadCallback) {
        this.name = name;
        this.configUrl = configUrl;
        this.reloadCallback = reloadCallback;
        this.addMatcher(DOMAIN_VALE_REGEX, this::handleDomain);
    }

    protected void addMatcher(Pattern pattern, MatcherHandler<CONTENT, VALUE> handler) {
        this.matcherHandlers.add(Pair.of((Object)pattern, handler));
    }

    public void reload() {
        this.unlock();
        this.reset();
        this.reloadCallback.accept(this);
        this.processData();
        this.sort(this.generalMatchers);
        this.contentMatchers.values().forEach(this::sort);
        this.defaultMatchers.values().forEach(this::sort);
        this.lock();
        this.outputParsingIssues();
        this.outputResults();
    }

    protected void outputParsingIssues() {
        if (!this.parsingIssues.isEmpty()) {
            ICBMClassic.logger().info("{}: parser documentation can be found at {}", (Object)this.getName(), (Object)this.configUrl);
            ICBMClassic.logger().error("{}: Parsing errors detected:", (Object)this.getName());
            this.parsingIssues.forEach((source, entries) -> {
                ICBMClassic.logger().error("\t{}", source);
                entries.forEach((entry, issues) -> {
                    ICBMClassic.logger().error("\t\t{}", entry);
                    issues.forEach(p -> {
                        if (((Boolean)p.getValue()).booleanValue()) {
                            ICBMClassic.logger().error("\t\t-{}", p.getKey());
                        } else {
                            ICBMClassic.logger().warn("\t\t-{}", p.getKey());
                        }
                    });
                });
            });
        }
    }

    protected void outputResults() {
    }

    protected void sort(List<ResourceConfigEntry<CONTENT, VALUE>> list) {
        int highestUserSort = list.stream().map(ResourceConfigEntry::getOrder).mapToInt(i -> i == null ? 0 : i).max().orElse(0);
        int index = 0;
        for (ResourceConfigEntry<CONTENT, VALUE> func : list) {
            if (func.getOrder() != null) continue;
            func.setOrder(highestUserSort + ++index);
        }
        list.sort(this::compare);
    }

    protected int compare(ResourceConfigEntry<CONTENT, VALUE> a, ResourceConfigEntry<CONTENT, VALUE> b) {
        int sortA = a.getOrder();
        int sortB = b.getOrder();
        return sortB - sortA;
    }

    protected void processData() {
    }

    private void unlock() {
        this.isLocked = false;
    }

    private void reset() {
        this.contentMatchers.clear();
        this.generalMatchers.clear();
        this.parsingIssues.clear();
    }

    private void lock() {
        this.isLocked = true;
    }

    public void setDefault(ResourceLocation key, VALUE value, int order) {
        this.defaultMatchers.computeIfAbsent(key, k -> new ArrayList()).add(new ResourceConfigEntry<CONTENT, VALUE>("default", order, this.getSimpleValue(key, value)));
    }

    public VALUE getValue(CONTENT state) {
        if (state == null) {
            return null;
        }
        ResourceLocation key = this.getContentKey(state);
        VALUE contentValue = this.getValue(state, this.contentMatchers.get(key));
        if (contentValue != null) {
            return contentValue;
        }
        for (Function function : this.generalMatchers) {
            Object result = function.apply(state);
            if (result == null) continue;
            this.matcherHit(state, function);
            return (VALUE)result;
        }
        return this.getValue(state, this.defaultMatchers.get(key));
    }

    private VALUE getValue(CONTENT state, List<ResourceConfigEntry<CONTENT, VALUE>> matchers) {
        if (matchers != null) {
            for (Function function : matchers) {
                Object result = function.apply(state);
                if (result == null) continue;
                this.matcherHit(state, function);
                return (VALUE)result;
            }
        }
        return null;
    }

    protected void matcherHit(CONTENT content, Function<CONTENT, VALUE> matcher) {
    }

    protected abstract ResourceLocation getContentKey(CONTENT var1);

    public void load(String source, String ... entries) {
        if (this.checkLock("entries", () -> String.join((CharSequence)", ", entries))) {
            return;
        }
        for (String str : entries) {
            this.handleEntry(source, str, null);
        }
    }

    private boolean checkLock(String type, Supplier<String> entry) {
        if (this.isLocked) {
            ICBMClassic.logger().error("{}: list is locked. Unable to add '{}' entry '{}'", (Object)this.name, (Object)type, (Object)entry.get(), (Object)new IllegalArgumentException());
            return true;
        }
        return false;
    }

    protected final boolean handleEntry(String source, String entryRaw, Integer index) {
        Matcher sortMatcher;
        String entry = entryRaw.replaceAll("\\s", "");
        if (entry.length() != entryRaw.length()) {
            this.warn(source, entry, "Entry contains extra whitespace characters '" + entryRaw + "'");
        }
        if ((sortMatcher = SORTING_REGEX.matcher(entry)).matches()) {
            return this.handleEntry(source, sortMatcher.group(2), Integer.parseInt(sortMatcher.group(1)));
        }
        for (Pair<Pattern, MatcherHandler<CONTENT, VALUE>> handlerEntry : this.matcherHandlers) {
            Matcher regexMatcher = ((Pattern)handlerEntry.getKey()).matcher(entry);
            if (!regexMatcher.matches()) continue;
            ResourceConfigEntry resourceConfigEntry = ((MatcherHandler)handlerEntry.getValue()).handle(regexMatcher, source, entry, index);
            if (resourceConfigEntry != null) {
                if (resourceConfigEntry.getKey() == null) {
                    this.generalMatchers.add(resourceConfigEntry);
                } else {
                    this.contentMatchers.computeIfAbsent(resourceConfigEntry.getKey(), k -> new ArrayList()).add(resourceConfigEntry);
                }
            }
            return true;
        }
        this.error(source, entry, "Unknown format");
        return false;
    }

    protected ResourceConfigEntry<CONTENT, VALUE> handleDomain(Matcher domainMatcher, String source, String entry, int index) {
        String domain = domainMatcher.group(1);
        if (!this.isDomainValid(domain)) {
            this.error(source, entry, "No matching mod domain found for '" + domain + "'");
            return null;
        }
        String valueStr = domainMatcher.group(2);
        VALUE value = null;
        if (valueStr != null && (value = (VALUE)this.parseValue(source, entry, valueStr)) == null) {
            return null;
        }
        Function<CONTENT, Object> matcher = this.getDomainValue(domain, value);
        if (matcher == null) {
            return null;
        }
        return new ResourceConfigEntry<CONTENT, Object>("resource_domain", index, matcher);
    }

    protected ResourceConfigEntry<CONTENT, VALUE> handleMeta(Matcher metaMatcher, String source, String entry, int index) {
        String resource;
        String domain = metaMatcher.group(1);
        ResourceLocation key = new ResourceLocation(domain, resource = metaMatcher.group(2));
        if (!this.isDomainValid(key.func_110624_b())) {
            this.error(source, entry, "No matching mod domain found for '" + key + "'");
            return null;
        }
        if (!this.isValidKey(key)) {
            this.error(source, entry, "No matching content found for '" + key + "'");
            return null;
        }
        int meta = Integer.parseInt(metaMatcher.group(3));
        String valueStr = metaMatcher.group(4);
        VALUE value = null;
        if (valueStr != null && (value = (VALUE)this.parseValue(source, entry, valueStr)) == null) {
            return null;
        }
        Function<CONTENT, Object> matcher = this.getMetaValue(key, meta, value);
        if (matcher == null) {
            return null;
        }
        return new ResourceConfigEntry<CONTENT, Object>("resource_metadata", index, matcher).setKey(key);
    }

    protected ResourceConfigEntry<CONTENT, VALUE> handleSimple(Matcher regexMatcher, String source, String entry, Integer index) {
        String resource;
        String domain = regexMatcher.group(1);
        ResourceLocation key = new ResourceLocation(domain, resource = regexMatcher.group(2));
        if (!this.isDomainValid(key.func_110624_b())) {
            this.error(source, entry, "No matching mod domain found for '" + key + "'");
            return null;
        }
        if (!this.isValidKey(key)) {
            this.error(source, entry, "No matching content found for '" + key + "'");
            return null;
        }
        String valueStr = regexMatcher.group(3);
        VALUE value = null;
        if (valueStr != null && (value = (VALUE)this.parseValue(source, entry, valueStr)) == null) {
            return null;
        }
        Function<CONTENT, Object> matcher = this.getSimpleValue(key, value);
        if (matcher == null) {
            return null;
        }
        return new ResourceConfigEntry<CONTENT, Object>("resource_simple", index, matcher).setKey(key);
    }

    protected Function<CONTENT, VALUE> getDomainValue(String domain, @Nullable VALUE value) {
        return content -> domain.equalsIgnoreCase(this.getContentKey(content).func_110624_b()) ? value : null;
    }

    protected Function<CONTENT, VALUE> getSimpleValue(ResourceLocation targetKey, @Nullable VALUE value) {
        if (targetKey.func_110623_a().startsWith("~") && targetKey.func_110623_a().endsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(1, targetKey.func_110623_a().length() - 1);
            return content -> {
                ResourceLocation contentKey = this.getContentKey(content);
                if (!targetKey.func_110624_b().equalsIgnoreCase(contentKey.func_110624_b())) {
                    return null;
                }
                return targetKey.func_110623_a().contains(checkStr) ? value : null;
            };
        }
        if (targetKey.func_110623_a().startsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(1);
            return content -> {
                ResourceLocation contentKey = this.getContentKey(content);
                if (!targetKey.func_110624_b().equalsIgnoreCase(contentKey.func_110624_b())) {
                    return null;
                }
                return targetKey.func_110623_a().endsWith(checkStr) ? value : null;
            };
        }
        if (targetKey.func_110623_a().endsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(0, targetKey.func_110623_a().length() - 1);
            return content -> {
                ResourceLocation contentKey = this.getContentKey(content);
                if (!targetKey.func_110624_b().equalsIgnoreCase(contentKey.func_110624_b())) {
                    return null;
                }
                return targetKey.func_110623_a().startsWith(checkStr) ? value : null;
            };
        }
        return content -> targetKey.equals((Object)this.getContentKey(content)) ? value : null;
    }

    protected Function<CONTENT, VALUE> getMetaValue(ResourceLocation key, int metadata, @Nullable VALUE value) {
        return null;
    }

    protected abstract VALUE parseValue(String var1, String var2, String var3);

    protected boolean isValidKey(ResourceLocation key) {
        return true;
    }

    protected boolean isDomainValid(String domain) {
        return "minecraft".equalsIgnoreCase(domain) || Loader.isModLoaded((String)domain);
    }

    protected void error(String source, String entry, String error) {
        this.issue(source, entry, error, true);
    }

    protected void warn(String source, String entry, String error) {
        this.issue(source, entry, error, false);
    }

    protected void issue(String source, String entry, String error, boolean isError) {
        this.parsingIssues.computeIfAbsent(source, k -> new HashMap()).computeIfAbsent(entry, k -> new ArrayList()).add(Pair.of((Object)error, (Object)isError));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }

    @FunctionalInterface
    protected static interface MatcherHandler<CONTENT, VALUE> {
        public ResourceConfigEntry<CONTENT, VALUE> handle(Matcher var1, String var2, String var3, Integer var4);
    }
}

