/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.util;

import icbm.classic.config.util.ResourceConfigEntry;
import icbm.classic.config.util.ResourceConfigList;
import icbm.classic.lib.ForgeRegistryHelpers;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class ItemStackConfigList<VALUE>
extends ResourceConfigList<ItemStackConfigList, ItemStack, VALUE> {
    public ItemStackConfigList(String name, Consumer<ItemStackConfigList> reloadCallback) {
        super(name, "https://github.com/BuiltBrokenModding/ICBM-Classic/wiki/config-itemstack", reloadCallback);
        this.addMatcher(META_KEY_REGEX, this::handleMeta);
        this.addMatcher(KEY_VALUE_REGEX, this::handleSimple);
    }

    @Override
    public VALUE getValue(ItemStack state) {
        if (state == null || state.func_190926_b()) {
            return null;
        }
        return super.getValue(state);
    }

    public void setDefaultMeta(ItemStack content, VALUE value, int order) {
        ResourceLocation key = content.func_77973_b().getRegistryName();
        this.defaultMatchers.computeIfAbsent(key, k -> new ArrayList()).add(new ResourceConfigEntry<ItemStack, Object>("default_metadata", order, itemStack -> ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)content) ? value : null));
    }

    @Override
    protected Function<ItemStack, VALUE> getMetaValue(ResourceLocation key, int metadata, @Nullable VALUE value) {
        return stack -> {
            if (this.getContentKey((ItemStack)stack) == key && stack.func_77960_j() == metadata) {
                return value;
            }
            return null;
        };
    }

    @Override
    protected boolean isValidKey(ResourceLocation targetKey) {
        return ForgeRegistryHelpers.contains(ForgeRegistries.ITEMS, targetKey);
    }

    @Override
    protected ResourceLocation getContentKey(ItemStack itemStack) {
        return itemStack.func_77973_b().getRegistryName();
    }

    public static class FloatOut
    extends ItemStackConfigList<Float> {
        public FloatOut(String name, Consumer<ItemStackConfigList> reloadCallback) {
            super(name, reloadCallback);
        }

        @Override
        protected Float parseValue(String source, String entry, String value) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                this.error(source, entry, "Value is not a Float");
                return null;
            }
        }
    }

    public static class IntOut
    extends ItemStackConfigList<Integer> {
        public IntOut(String name, Consumer<ItemStackConfigList> reloadCallback) {
            super(name, reloadCallback);
        }

        @Override
        protected Integer parseValue(String source, String entry, String value) {
            try {
                return Integer.parseInt(value, 10);
            }
            catch (NumberFormatException e) {
                this.error(source, entry, "Value is not an integer");
                return null;
            }
        }
    }

    public static class ContainsCheck
    extends ItemStackConfigList<Boolean> {
        public ContainsCheck(String name, Consumer<ItemStackConfigList> reloadCallback) {
            super(name, reloadCallback);
        }

        public boolean isContained(ItemStack stack) {
            Boolean value = (Boolean)super.getValue(stack);
            return value != null && value != false;
        }

        public boolean isAllowed(ItemStack stack, boolean ban) {
            return ban && !this.isContained(stack) || !ban && this.isContained(stack);
        }

        @Override
        protected Function<ItemStack, Boolean> getDomainValue(String domain, Boolean disable) {
            if (Boolean.TRUE.equals(disable)) {
                return null;
            }
            return super.getDomainValue(domain, true);
        }

        @Override
        protected Function<ItemStack, Boolean> getSimpleValue(ResourceLocation targetKey, Boolean disable) {
            if (Boolean.TRUE.equals(disable)) {
                return null;
            }
            return super.getSimpleValue(targetKey, true);
        }

        @Override
        protected Function<ItemStack, Boolean> getMetaValue(ResourceLocation key, int metadata, @Nullable Boolean disable) {
            if (Boolean.TRUE.equals(disable)) {
                return null;
            }
            return super.getMetaValue(key, metadata, true);
        }

        @Override
        protected Boolean parseValue(String source, String entry, String value) {
            return Boolean.parseBoolean(value);
        }
    }
}

