/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.util;

import com.google.common.collect.ImmutableMap;
import icbm.classic.ICBMClassic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockStateConfigListOld {
    private final String name;
    private final Consumer<BlockStateConfigListOld> reloadCallback;
    final List<String> mods = new ArrayList<String>();
    final Map<String, List<Function<Block, Boolean>>> fuzzyBlockChecks = new HashMap<String, List<Function<Block, Boolean>>>();
    final HashSet<IBlockState> blockStates = new HashSet();
    final HashSet<Block> blocks = new HashSet();
    final Map<Block, List<Function<IBlockState, Boolean>>> blockStateMatchers = new HashMap<Block, List<Function<IBlockState, Boolean>>>();
    private boolean isLocked = false;

    public void reload() {
        this.unlock();
        this.reset();
        this.reloadCallback.accept(this);
        this.batchBlockRegistry();
        this.lock();
    }

    private void unlock() {
        this.isLocked = false;
    }

    private void reset() {
        this.blockStates.clear();
        this.blocks.clear();
    }

    private void lock() {
        this.isLocked = true;
        this.mods.clear();
        this.fuzzyBlockChecks.clear();
    }

    public void batchBlockRegistry() {
        if (this.isLocked) {
            ICBMClassic.logger().error(this.name + ": list is locked but loading was invoked!!", (Throwable)new IllegalArgumentException());
            return;
        }
        ForgeRegistries.BLOCKS.forEach(block -> {
            String modId = Objects.requireNonNull(block.getRegistryName()).func_110624_b();
            if (this.mods.contains(modId)) {
                this.blocks.add((Block)block);
            }
            if (this.fuzzyBlockChecks.containsKey(modId) && this.fuzzyBlockChecks.get(modId).stream().anyMatch(func -> (Boolean)func.apply(block))) {
                this.blocks.add((Block)block);
            }
        });
        this.lock();
    }

    public boolean contains(IBlockState state) {
        if (state == null) {
            return false;
        }
        if (this.blocks.contains(state.func_177230_c()) || this.blockStates.contains(state)) {
            return true;
        }
        if (Optional.ofNullable(this.blockStateMatchers.get(state.func_177230_c())).map(l -> l.stream().anyMatch(f -> (Boolean)f.apply(state))).orElse(false).booleanValue()) {
            this.blockStates.add(state);
            return true;
        }
        return false;
    }

    public void loadBlockStates(Iterable<String> entries) {
        if (this.checkLock("blocks", () -> String.join((CharSequence)", ", entries))) {
            return;
        }
        entries.forEach(str -> {
            String entry = str.trim();
            this.handleEntry(entry);
        });
    }

    public void loadBlockStates(String ... entries) {
        if (this.checkLock("blocks", () -> String.join((CharSequence)", ", entries))) {
            return;
        }
        for (String str : entries) {
            String entry = str.trim();
            this.handleEntry(entry);
        }
    }

    public void addMod(String mod) {
        if (this.checkLock("mod", () -> mod)) {
            return;
        }
        this.mods.add(mod);
    }

    private boolean checkLock(String type, Supplier<String> entry) {
        if (this.isLocked) {
            ICBMClassic.logger().error(this.name + ": list is locked. Unable to add '" + type + "' entry '" + entry.get() + "'", (Throwable)new IllegalArgumentException());
            return true;
        }
        return false;
    }

    boolean handleEntry(String entry) {
        try {
            if (entry.contains("@")) {
                return this.handleMetaData(entry);
            }
            if (entry.contains("[")) {
                return this.handleBlockState(entry);
            }
            if (entry.contains("~")) {
                return this.handleFuzzyBlocks(entry);
            }
            return this.handleSimpleBlock(entry);
        }
        catch (Exception e) {
            ICBMClassic.logger().error(this.name + ": Unexpected error parsing `" + entry + "` for banAllow list.", (Throwable)e);
            return false;
        }
    }

    boolean handleSimpleBlock(String entry) {
        ResourceLocation blockKey = this.getBlockKey(entry);
        if (blockKey == null) {
            return false;
        }
        if (!ForgeRegistries.BLOCKS.containsKey(blockKey)) {
            ICBMClassic.logger().error(this.name + ": Failed to find block matching entry `" + entry + "`");
            return false;
        }
        return this.blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockKey));
    }

    ResourceLocation getBlockKey(String entry) {
        String key;
        String[] keySplit = entry.split(":", -1);
        String domain = keySplit.length == 2 ? keySplit[0].trim() : null;
        String string = key = keySplit.length == 2 ? keySplit[1].trim() : null;
        if (keySplit.length != 2 || domain.isEmpty() || key.isEmpty()) {
            return null;
        }
        return new ResourceLocation(domain, key);
    }

    boolean handleMetaData(String entry) {
        int desiredMetadata;
        String[] metaSplit = entry.split("@");
        if (metaSplit.length != 2 || !metaSplit[1].matches("\\d+") || !metaSplit[0].contains(":")) {
            ICBMClassic.logger().error(this.name + ": Detected invalid metadata format for `" + entry + "`  for banAllow list. Expected `mod:key@number` example: `minecraft:stone@2`");
            return false;
        }
        ResourceLocation blockKey = this.getBlockKey(metaSplit[0]);
        if (blockKey == null) {
            ICBMClassic.logger().error(this.name + ": Detected invalid metadata format for `" + entry + "`  for banAllow list. Expected `mod:key@number` example: `minecraft:stone@2`");
            return false;
        }
        if (!ForgeRegistries.BLOCKS.containsKey(blockKey)) {
            ICBMClassic.logger().error(this.name + ": Failed to find block matching entry `" + entry + "` for banAllow list.");
            return false;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockKey);
        IBlockState state = block.func_176203_a(desiredMetadata = Integer.parseInt(metaSplit[1]));
        if (state == null) {
            ICBMClassic.logger().error(this.name + ": Failed to find state matching entry `" + entry + "` for banAllow list. This is a bug in '" + blockKey.func_110624_b() + "'!");
            return false;
        }
        int metaActual = block.func_176201_c(state);
        if (desiredMetadata != metaActual) {
            ICBMClassic.logger().error(this.name + ": Block returned a state with metadata[" + metaActual + "] but it didn't match metadata[" + desiredMetadata + "] for entry `" + entry + "` for banAllow list.");
            return false;
        }
        return this.blockStates.add(state);
    }

    boolean handleBlockState(String entry) {
        String[] nameVsPropSplit = entry.split("\\[");
        ResourceLocation regName = this.getBlockKey(nameVsPropSplit[0]);
        if (regName == null) {
            return false;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(regName);
        if (block == null) {
            ICBMClassic.logger().error("Config Flying Block: Failed to find block '" + regName + "' matching entry `" + entry + "` for banAllow list.");
            return false;
        }
        String[] properties = nameVsPropSplit[1].replace("]", "").split(",");
        HashMap<IProperty, Function<Comparable, Boolean>> matchers = new HashMap<IProperty, Function<Comparable, Boolean>>();
        for (String propEntry : properties) {
            List valuesToMatch;
            String stringMatch;
            String[] stateSplit = propEntry.split(":");
            String propName = stateSplit[0].trim();
            String propValue = stateSplit[1].trim();
            IProperty property = block.func_176194_O().func_185920_a(propName);
            if (property == null) {
                ICBMClassic.logger().error("Config Flying Block: Failed to find property '" + propName + "' for block '" + regName + "' matching entry `" + entry + "` for banAllow list.");
                return false;
            }
            if (propValue.equals("~")) {
                matchers.put(property, o -> true);
                continue;
            }
            if (propValue.startsWith("~")) {
                stringMatch = propValue.substring(1).trim();
                valuesToMatch = property.func_177700_c().stream().filter(o -> property.func_177702_a((Comparable)o).endsWith(stringMatch)).collect(Collectors.toList());
                if (valuesToMatch.isEmpty()) {
                    ICBMClassic.logger().error("Config Flying Block: Failed to find values matching '" + propValue + "' for property '" + propName + "' and block '" + regName + "' matching entry `" + entry + "`");
                    return false;
                }
                matchers.put(property, valuesToMatch::contains);
                continue;
            }
            if (propValue.endsWith("~")) {
                stringMatch = propValue.substring(0, propValue.length() - 1).trim();
                valuesToMatch = property.func_177700_c().stream().filter(o -> property.func_177702_a((Comparable)o).startsWith(stringMatch)).collect(Collectors.toList());
                if (valuesToMatch.isEmpty()) {
                    ICBMClassic.logger().error("Config Flying Block: Failed to find values matching '" + propValue + "' for property '" + propName + "' and block '" + regName + "' matching entry `" + entry + "`");
                    return false;
                }
                matchers.put(property, valuesToMatch::contains);
                continue;
            }
            Optional<Object> value = property.func_177700_c().stream().filter(o -> property.func_177702_a((Comparable)o).equalsIgnoreCase(propValue)).findFirst();
            if (!value.isPresent()) {
                ICBMClassic.logger().error("Config Flying Block: Failed to find value '" + propValue + "' for property '" + propName + "' and block '" + regName + "' matching entry `" + entry + "`");
                return false;
            }
            matchers.put(property, o -> Objects.equals(value.get(), o));
        }
        if (matchers.isEmpty()) {
            return false;
        }
        if (!this.blockStateMatchers.containsKey(block)) {
            this.blockStateMatchers.put(block, new ArrayList());
        }
        return this.blockStateMatchers.get(block).add(blockState -> this.matchesFuzzyState((IBlockState)blockState, (Map<IProperty, Function<Comparable, Boolean>>)matchers));
    }

    boolean matchesFuzzyState(IBlockState state, Map<IProperty, Function<Comparable, Boolean>> matchers) {
        ImmutableMap stateProps = state.func_177228_b();
        for (IProperty propKey : matchers.keySet()) {
            if (!stateProps.containsKey((Object)propKey)) {
                return false;
            }
            Function<Comparable, Boolean> check = matchers.get(propKey);
            if (check == null || check.apply((Comparable)stateProps.get((Object)propKey)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    boolean handleFuzzyBlocks(String entry) {
        String[] split = entry.split(":");
        if (split.length != 2 || split[1].lastIndexOf("~") != split[1].indexOf("~") || split[0].contains("~") || split[0].isEmpty()) {
            ICBMClassic.logger().error(this.name + ": Detected invalid fuzzy format for `" + entry + "`  for banAllow list. Expected `mod:~`, `mod:key~` or `mod:~key`");
            return false;
        }
        String domain = split[0].trim();
        String resource = split[1].trim();
        if (Objects.equals(resource, "~")) {
            return this.mods.add(domain);
        }
        if (resource.endsWith("~")) {
            this.addFuzzyForBlock(domain, block -> this.blockPathStartsWith((Block)block, resource.substring(0, resource.length() - 1)));
            return true;
        }
        if (resource.startsWith("~")) {
            this.addFuzzyForBlock(domain, block -> this.blockPathEndsWith((Block)block, resource.substring(1)));
            return true;
        }
        ICBMClassic.logger().error(this.name + ": Couldn't match fuzzy format for `" + entry + "`  for banAllow list. Expected `mod:~`, `mod:key~` or `mod:~key`");
        return false;
    }

    boolean blockPathStartsWith(Block block, String value) {
        return Objects.requireNonNull(block.getRegistryName()).func_110623_a().startsWith(value);
    }

    boolean blockPathEndsWith(Block block, String value) {
        return Objects.requireNonNull(block.getRegistryName()).func_110623_a().endsWith(value);
    }

    void addFuzzyForBlock(String domain, Function<Block, Boolean> check) {
        if (!this.fuzzyBlockChecks.containsKey(domain)) {
            this.fuzzyBlockChecks.put(domain, new ArrayList());
        }
        this.fuzzyBlockChecks.get(domain).add(check);
    }

    public List<String> dumpBlocksContained() {
        ArrayList<String> list = new ArrayList<String>();
        ForgeRegistries.BLOCKS.forEach(block -> {
            if (this.contains(block.func_176223_P())) {
                list.add(block.getRegistryName().toString());
            }
        });
        return list;
    }

    @Generated
    public BlockStateConfigListOld(String name, Consumer<BlockStateConfigListOld> reloadCallback) {
        this.name = name;
        this.reloadCallback = reloadCallback;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }
}

