/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config;

import net.minecraftforge.common.config.Config;

@Config(modid="icbmclassic", name="icbmclassic/emp")
@Config.LangKey(value="config.icbmclassic:emp.title")
public class ConfigEMP {
    @Config.Name(value="allow_creeper_charging")
    @Config.Comment(value={"Should a lighting effect be applied to the creeper to super charge it due to EMP effect?"})
    public static boolean ALLOW_LIGHTING_CREEPER = true;
    @Config.Name(value="missiles")
    @Config.Comment(value={"EMP Settings for missiles"})
    public static final Missiles missiles = new Missiles();
    @Config.Name(value="allow_entity_inventory")
    @Config.Comment(value={"Should EMP effect run on entity inventories? (Eg. Player, Cart)"})
    public static boolean ALLOW_ENTITY_INVENTORY = true;
    @Config.Name(value="allow_tile_inventory")
    @Config.Comment(value={"Should EMP effect run on block/tile inventories? (Eg. Chest, Hopper, Machine)"})
    public static boolean ALLOW_TILE_INVENTORY = true;
    @Config.Name(value="allow_item_inventory")
    @Config.Comment(value={"Should EMP effect run on item inventories? (Eg. Bag, Backpack)"})
    public static boolean ALLOW_ITEM_INVENTORY = true;
    @Config.Name(value="allow_ground_items")
    @Config.Comment(value={"Should EMP effect run on items dropped on the ground?"})
    public static boolean ALLOW_GROUND_ITEMS = true;
    @Config.Name(value="allow_draining_energy_entity")
    @Config.Comment(value={"Should EMP effect drain energy entities that do not support EMP effect directly?"})
    public static boolean DRAIN_ENERGY_ENTITY = true;
    @Config.Name(value="allow_draining_energy_items")
    @Config.Comment(value={"Should EMP effect drain energy items that do not support EMP effect directly?"})
    public static boolean DRAIN_ENERGY_ITEMS = true;
    @Config.Name(value="allow_draining_energy_tiles")
    @Config.Comment(value={"Should EMP effect drain energy tiles that do not support EMP effect directly?"})
    public static boolean DRAIN_ENERGY_TILES = true;
    @Config.Name(value="allow_entities")
    @Config.Comment(value={"Should EMP effect run on entities?"})
    public static boolean ALLOW_ENTITY = true;
    @Config.Name(value="allow_tiles")
    @Config.Comment(value={"Should EMP effect run on blocks and tiles?"})
    public static boolean ALLOW_TILES = true;

    public static class Missiles {
        @Config.Name(value="enabled")
        @Config.Comment(value={"Should EMP work on missiles"})
        public boolean enabled = true;
        @Config.Name(value="engine_kill_chance")
        @Config.Comment(value={"Chance the engine will be disabled, random <= chance"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float engineKillChance = 0.8f;
        @Config.Name(value="engine_fuel_blow_chance")
        @Config.Comment(value={"Chance that when the missile is killed the fuel will detonate, random <= chance"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float engineFullBlowChance = 1.0f;
        @Config.Name(value="engine_fuel_blow_strength")
        @Config.Comment(value={"Power of the explosion from the fuel"})
        @Config.RangeDouble(min=0.1)
        public float engineFullBlowStrength = 1.0f;
        @Config.Name(value="missile_kill_chance")
        @Config.Comment(value={"Chance the missile will be destroyed, random <= chance"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float missileKillChance = 0.5f;
        @Config.Name(value="missile_trigger_chance")
        @Config.Comment(value={"Chance the missile explosive will be triggered, random <= chance"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float missileTriggerChance = 0.1f;
    }
}

