/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render.entity.item;

import icbm.classic.lib.data.LazyBuilder;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderItemImp<E extends Entity>
extends Render<E> {
    private final RenderItem itemRenderer;
    private final Random random = new Random();
    private static final Supplier<ItemStack> BACKUP_RENDER_STACK = new LazyBuilder<ItemStack>(() -> new ItemStack((Block)Blocks.field_150480_ab));
    protected boolean billboard = false;

    public RenderItemImp(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
        this.field_76989_e = 0.15f;
        this.field_76987_f = 0.75f;
    }

    @Nonnull
    protected abstract ItemStack getRenderItem(E var1, int var2);

    protected ItemCameraTransforms.TransformType getTransformType(int index) {
        return ItemCameraTransforms.TransformType.NONE;
    }

    protected void translate(@Nullable E entity, ItemStack itemstack, IBakedModel iBakedModel, double x, double y, double z, float partialTicks, int index) {
        float hoverStart = iBakedModel.func_177552_f().func_181688_b((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).field_178363_d.y;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.25f * hoverStart), (float)((float)z));
    }

    protected void rotate(@Nullable E entity, ItemStack itemstack, float entityYaw, float entityPitch, float partialTicks, int index) {
        if (this.billboard) {
            GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    protected void scale(@Nullable E e, ItemStack itemstack, float partialTicks, int index) {
    }

    public void func_76986_a(@Nonnull E entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float yaw = this.getYaw(entity, entityYaw, partialTicks);
        float entityPitch = ((Entity)entity).field_70127_C + (((Entity)entity).field_70125_A - ((Entity)entity).field_70127_C) * partialTicks;
        float pitch = this.getPitch(entity, entityPitch, partialTicks);
        this.doRenderItem(entity, ((Entity)entity).field_70170_p, x, y, z, yaw, pitch, partialTicks);
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
    }

    protected void doRenderItem(@Nonnull E entity, World world, double x, double y, double z, float yaw, float pitch, float partialTicks) {
        this.renderItem(entity, this.getRenderItem(entity, 0), ((Entity)entity).field_70170_p, x, y, z, yaw, pitch, partialTicks, 0);
    }

    protected float getYaw(@Nonnull E entity, float providedYaw, float partialTicks) {
        return providedYaw;
    }

    protected float getPitch(@Nonnull E entity, float entityPitch, float partialTicks) {
        return ((Entity)entity).field_70125_A;
    }

    protected IBakedModel getBakedModel(@Nullable E entity, World world, ItemStack stack) {
        return this.itemRenderer.func_184393_a(stack, world, (EntityLivingBase)null);
    }

    public void renderItem(ItemStack missileStack, World world, double x, double y, double z, float entityYaw, float entityPitch, float partialTicks) {
        this.renderItem(null, missileStack, world, x, y, z, entityYaw, entityPitch, partialTicks, 0);
    }

    protected void renderItem(@Nullable E entity, ItemStack itemstack, World world, double x, double y, double z, float entityYaw, float entityPitch, float partialTicks, int index) {
        if (itemstack == null || itemstack.func_190926_b()) {
            itemstack = BACKUP_RENDER_STACK.get();
        }
        this.random.setSeed(Item.func_150891_b((Item)itemstack.func_77973_b()) + itemstack.func_77960_j());
        boolean hasTexture = false;
        if (this.func_180548_c((Entity)entity)) {
            this.field_76990_c.field_78724_e.func_110581_b(this.func_110775_a(entity)).func_174936_b(false, false);
            hasTexture = true;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        IBakedModel ibakedmodel = this.getBakedModel(entity, world, itemstack);
        this.translate(entity, itemstack, ibakedmodel, x, y, z, partialTicks, index);
        this.rotate(entity, itemstack, entityYaw, entityPitch, partialTicks, index);
        this.scale(entity, itemstack, partialTicks, index);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        GlStateManager.func_179094_E();
        ibakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)this.getTransformType(index), (boolean)false);
        this.itemRenderer.func_180454_a(itemstack, ibakedmodel);
        GlStateManager.func_179121_F();
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        this.func_180548_c((Entity)entity);
        if (hasTexture) {
            this.field_76990_c.field_78724_e.func_110581_b(this.func_110775_a(entity)).func_174935_a();
        }
    }

    @Nonnull
    protected ResourceLocation func_110775_a(@Nullable E entity) {
        return TextureMap.field_110575_b;
    }

    @Generated
    public RenderItemImp<E> setBillboard(boolean billboard) {
        this.billboard = billboard;
        return this;
    }

    @Generated
    public boolean isBillboard() {
        return this.billboard;
    }
}

