/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.loaders.recipes;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.loaders.recipe.handlers.RecyclingRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.unification.material.info.SuSyMaterialFlags;
import supersymmetry.api.unification.material.properties.FiberProperty;
import supersymmetry.api.unification.material.properties.SuSyPropertyKey;
import supersymmetry.api.unification.ore.SusyOrePrefix;
import supersymmetry.common.item.SuSyMetaItems;

public class SuSyMaterialRecipeHandler {
    public static void init() {
        SusyOrePrefix.catalystBed.addProcessingHandler(PropertyKey.DUST, SuSyMaterialRecipeHandler::processCatalystBed);
        SusyOrePrefix.catalystPellet.addProcessingHandler(PropertyKey.DUST, SuSyMaterialRecipeHandler::processCatalystPellet);
        SusyOrePrefix.sheetedFrame.addProcessingHandler(PropertyKey.DUST, SuSyMaterialRecipeHandler::processSheetedFrame);
        SusyOrePrefix.sheetedFrame.addProcessingHandler(PropertyKey.DUST, RecyclingRecipeHandler::processCrushing);
        SusyOrePrefix.fiber.addProcessingHandler(SuSyPropertyKey.FIBER, SuSyMaterialRecipeHandler::processFiber);
        SusyOrePrefix.thread.addProcessingHandler(SuSyPropertyKey.FIBER, SuSyMaterialRecipeHandler::processThread);
        SusyOrePrefix.thread.addProcessingHandler(SuSyPropertyKey.FIBER, SuSyMaterialRecipeHandler::processThreadWeaving);
        SusyOrePrefix.fiber.addProcessingHandler(PropertyKey.DUST, RecyclingRecipeHandler::processCrushing);
        SusyOrePrefix.thread.addProcessingHandler(PropertyKey.DUST, RecyclingRecipeHandler::processCrushing);
    }

    public static void processCatalystBed(OrePrefix catalystBedPrefix, Material mat, DustProperty property) {
        if (mat.hasFlag(SuSyMaterialFlags.GENERATE_CATALYST_BED)) {
            ModHandler.addShapedRecipe((String)String.format("catalyst_bed_%s", mat), (ItemStack)OreDictUnifier.get((OrePrefix)catalystBedPrefix, (Material)mat, (int)1), (Object[])new Object[]{" S ", "SCS", " S ", Character.valueOf('S'), new UnificationEntry(SusyOrePrefix.catalystPellet, mat), Character.valueOf('C'), SuSyMetaItems.CATALYST_BED_SUPPORT_GRID});
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).input(SusyOrePrefix.catalystPellet, mat, 4)).input(SuSyMetaItems.CATALYST_BED_SUPPORT_GRID)).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)catalystBedPrefix, (Material)mat, (int)1)})).EUt(GTValues.VA[0])).duration(64)).buildAndRegister();
        }
    }

    public static void processCatalystPellet(OrePrefix catalystPelletPrefix, Material mat, DustProperty property) {
        if (mat.hasFlag(SuSyMaterialFlags.GENERATE_CATALYST_PELLET)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).input(OrePrefix.dust, mat, 1)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)catalystPelletPrefix, (Material)mat, (int)4)})).EUt(GTValues.VA[0])).duration(64)).buildAndRegister();
        }
    }

    public static void processFiber(OrePrefix fiberPrefix, Material mat, @NotNull FiberProperty property) {
        if (property.solutionSpun) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)SuSyRecipeMaps.DRYER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)SusyOrePrefix.wetFiber, (Material)mat, (int)8)})).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)fiberPrefix, (Material)mat, (int)8)})).duration(20)).EUt(GTValues.VA[3])).buildAndRegister();
        }
    }

    public static void processThread(OrePrefix threadPrefix, Material mat, @NotNull FiberProperty property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)SuSyRecipeMaps.SPINNING_RECIPES.recipeBuilder()).inputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)SusyOrePrefix.fiber, (Material)mat, (int)4)})).fluidInputs(new FluidStack[]{Materials.Air.getFluid(100)})).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)threadPrefix, (Material)mat, (int)1)})).duration(20)).EUt(GTValues.VA[1])).buildAndRegister();
    }

    public static void processThreadWeaving(OrePrefix threadPrefix, Material mat, @NotNull FiberProperty property) {
        if (mat.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).inputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)threadPrefix, (Material)mat, (int)8)})).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)mat, (int)1)})).duration(20)).EUt(GTValues.VA[1])).buildAndRegister();
        }
    }

    public static void processSheetedFrame(OrePrefix sheetedFramePrefix, Material mat, DustProperty property) {
        if (!mat.hasFlag(MaterialFlags.GENERATE_FRAME)) {
            return;
        }
        ModHandler.addShapedRecipe((String)String.format("%s_sheeted_frame", mat), (ItemStack)OreDictUnifier.get((OrePrefix)sheetedFramePrefix, (Material)mat, (int)12), (Object[])new Object[]{"PFP", "PHP", "PFP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, mat), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, mat), Character.valueOf('H'), ToolItems.HARD_HAMMER});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).input(OrePrefix.plate, mat, 3)).input(OrePrefix.frameGt, mat, 1)).output(SusyOrePrefix.sheetedFrame, mat, 6)).EUt(7)).duration(225)).circuitMeta(10)).buildAndRegister();
    }
}

