/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.loaders;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.blocks.SusyStoneVariantBlock;
import supersymmetry.common.item.SuSyMetaItems;

public class SusyOreDictionaryLoader {
    public static void init() {
        SusyOreDictionaryLoader.loadStoneOredict();
    }

    public static void loadStoneOredict() {
        ItemStack cobble;
        ItemStack smooth;
        for (SusyStoneVariantBlock.StoneType stoneType : SusyStoneVariantBlock.StoneType.values()) {
            smooth = SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.SMOOTH).getItemVariant(stoneType);
            cobble = SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.COBBLE).getItemVariant(stoneType);
            OreDictUnifier.registerOre((ItemStack)smooth, (OrePrefix)stoneType.getOrePrefix(), (Material)stoneType.getMaterial());
            OreDictionary.registerOre((String)"stone", (ItemStack)smooth);
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)cobble);
        }
        for (SusyStoneVariantBlock.StoneType stoneType : StoneVariantBlock.StoneType.values()) {
            smooth = ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getItemVariant((Enum)stoneType);
            cobble = ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.COBBLE)).getItemVariant((Enum)stoneType);
            OreDictionary.registerOre((String)"stone", (ItemStack)smooth);
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)cobble);
        }
        ItemStack concreteLightSmooth = ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getItemVariant((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT);
        OreDictionary.registerOre((String)"railBed", (ItemStack)concreteLightSmooth);
        ItemStack trackSegmentStack = SuSyMetaItems.TRACK_SEGMENT.getStackForm();
        OreDictionary.registerOre((String)"trackMaglev", (ItemStack)trackSegmentStack);
    }
}

