/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.integration.theoneprobe.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import supersymmetry.common.metatileentities.multi.electric.MetaTileEntityEvaporationPool;

public class EvaporationPoolInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "susy:evaporation_pool_provider";
    }

    public void addProbeInfo(@Nonnull ProbeMode mode, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull IBlockState blockState, @Nonnull IProbeHitData data) {
        if (blockState.func_177230_c().hasTileEntity(blockState)) {
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return;
            }
            MetaTileEntity metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (metaTileEntity instanceof MetaTileEntityEvaporationPool) {
                MetaTileEntityEvaporationPool evapPool = (MetaTileEntityEvaporationPool)metaTileEntity;
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.evaporation_pool_heated_preface*} " + (evapPool.isHeated ? TextFormatting.GREEN + "{*gregtech.top.evaporation_pool_is_heated*} " : TextFormatting.RED + "{*gregtech.top.evaporation_pool_not_heated*} "));
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.multiblock.evaporation_pool.average_speed*} " + TextFormatting.GREEN + evapPool.getAverageRecipeSpeedString() + TextFormatting.WHITE + "x");
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.evaporation_pool.energy_transferred*} " + TextFormatting.YELLOW + evapPool.getKiloJoules() + "." + TextFormatting.YELLOW + EvaporationPoolInfoProvider.constLengthToString(evapPool.getJoulesBuffer()) + TextFormatting.WHITE + " {*gregtech.top.evaporation_pool.kilojoules*}");
            }
        }
    }

    public static String constLengthToString(int i) {
        String result = Integer.toString(i);
        if (i < 1000) {
            char[] padding = new char[3 - result.length()];
            Arrays.fill(padding, '0');
            return padding + result;
        }
        return result.substring(result.length() - 3);
    }
}

