/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SusyMetaTileEntityDumpingHatch
extends MetaTileEntityMultiblockPart {
    private boolean frontFaceFree = false;

    public SusyMetaTileEntityDumpingHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 1);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SusyMetaTileEntityDumpingHatch(this.metaTileEntityId);
    }

    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 10L == 0L) {
            this.frontFaceFree = this.checkFrontFaceFree();
        }
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.getController();
        if (this.getWorld().field_72995_K && controller != null && controller.isActive()) {
            this.dumpingParticles();
        }
    }

    public boolean isFrontFaceFree() {
        return this.frontFaceFree;
    }

    private boolean checkFrontFaceFree() {
        BlockPos frontPos = this.getPos().func_177972_a(this.getFrontFacing());
        IBlockState blockState = this.getWorld().func_180495_p(frontPos);
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), frontPos);
    }

    @SideOnly(value=Side.CLIENT)
    public void dumpingParticles() {
        BlockPos pos = this.getPos();
        EnumFacing facing = this.getFrontFacing();
        float xPos = (float)facing.func_82601_c() * 0.76f + (float)pos.func_177958_n() + 0.25f;
        float yPos = (float)facing.func_96559_d() * 0.76f + (float)pos.func_177956_o() + 0.25f;
        float zPos = (float)facing.func_82599_e() * 0.76f + (float)pos.func_177952_p() + 0.25f;
        float ySpd = -0.3f - 0.05f * GTValues.RNG.nextFloat();
        float xSpd = (float)facing.func_82601_c() * 0.3f + 0.05f * GTValues.RNG.nextFloat();
        float zSpd = (float)facing.func_82599_e() * 0.3f + 0.05f * GTValues.RNG.nextFloat();
        if (this.getController() instanceof MultiblockWithDisplayBase) {
            this.getWorld().func_175688_a(EnumParticleTypes.WATER_DROP, (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
        }
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.MUFFLER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    protected boolean openGUIOnRightClick() {
        return false;
    }
}

