/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.capability.impl.ExtendedDTLogicHandler;
import supersymmetry.api.metatileentity.multiblock.MetaTileEntityOrderedDT;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityVacuumDistillationTower
extends MetaTileEntityOrderedDT {
    public MetaTileEntityVacuumDistillationTower(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.VACUUM_DISTILLATION_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityVacuumDistillationTower(this.metaTileEntityId);
    }

    @Override
    @NotNull
    public DistillationTowerLogicHandler createHandler() {
        return new ExtendedDTLogicHandler(this, 3, ignored -> 3);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{" CSC  ", "CCCCCC", "CCCCCC", "CCCCCC", " CCC  "}).aisle(new String[]{" CGC  ", "C#F#CC", "IFFF#P", "C#F#CC", " CCC  "}).aisle(new String[]{" CCC  ", "C#F#CC", "CFFFCC", "C#F#CC", " CCC  "}).aisle(new String[]{" XXX  ", "X#F#D ", "XFFFD ", "X#F#D ", " XXX  "}).setRepeatable(1, 12).aisle(new String[]{" DDD  ", "DDDDD ", "DDDDD ", "DDDDD ", " DDD  "}).where('S', this.selfPredicate()).where('G', MetaTileEntityVacuumDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntityVacuumDistillationTower.getGlassState()})).where('P', MetaTileEntityVacuumDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntityVacuumDistillationTower.getPipeCasingState()})).where('F', MetaTileEntityVacuumDistillationTower.frames((Material[])new Material[]{Materials.Steel})).where('C', MetaTileEntityVacuumDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntityVacuumDistillationTower.getCasingState()}).or(MetaTileEntityVacuumDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntityVacuumDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(2)).or(MetaTileEntityVacuumDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setMaxGlobalLimited(1))).where('I', MetaTileEntityVacuumDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setMaxGlobalLimited(1)).where('D', MetaTileEntityVacuumDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntityVacuumDistillationTower.getCasingState()})).where('X', MetaTileEntityVacuumDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntityVacuumDistillationTower.getCasingState()}).or(MetaTileEntityVacuumDistillationTower.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])((List)MultiblockAbility.REGISTRY.get(MultiblockAbility.EXPORT_FLUIDS)).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new))).setMaxLayerLimited(1)).or(this.autoAbilities(true, false))).where('#', MetaTileEntityVacuumDistillationTower.air()).build();
    }

    protected static IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS);
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    protected static IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.VDT_OVERLAY;
    }
}

