/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.metatileentity.multiblock.SuSyPredicates;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.SinterProperty;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.blocks.BlockSinteringBrick;
import supersymmetry.common.blocks.BlockSuSyMultiblockCasing;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntitySinteringOven
extends RecipeMapMultiblockController {
    private boolean canUsePlasma;

    public MetaTileEntitySinteringOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.SINTERING_RECIPES);
        this.recipeMapWorkable = new MultiblockRecipeLogic((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntitySinteringOven(this.metaTileEntityId);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.sintering_oven.can_use_plasma", new Object[]{new TextComponentTranslation(this.canUsePlasma ? "gregtech.multiblocks.sintering_oven.use_plasma.affirmative" : "gregtech.multiblocks.sintering_oven.use_plasma.negative", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE))}));
        }
        super.addDisplayText(textList);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart multiblockPart) {
        return SusyTextures.ULV_STRUCTURAL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.SINTERING_OVERLAY;
    }

    protected static IBlockState getCasingState() {
        return SuSyBlocks.MULTIBLOCK_CASING.getState(BlockSuSyMultiblockCasing.CasingType.ULV_STRUCTURAL_CASING);
    }

    @NotNull
    public BlockPattern createStructurePattern() {
        TraceabilityPredicate casingPredicate = MetaTileEntitySinteringOven.states((IBlockState[])new IBlockState[]{MetaTileEntitySinteringOven.getCasingState()}).setMinGlobalLimited(33);
        return FactoryBlockPattern.start().aisle(new String[]{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}).aisle(new String[]{"     ", " BBB ", " B#B ", " BBB ", "     "}).aisle(new String[]{"FFFFF", "FBBBF", "FB#BF", " BBB ", "     "}).aisle(new String[]{"     ", " BBB ", " B#B ", " BBB ", "     "}).aisle(new String[]{"FFFFF", "FBBBF", "FB#BF", " BBB ", "     "}).aisle(new String[]{"     ", " BBB ", " B#B ", " BBB ", "     "}).aisle(new String[]{"FFFFF", "FBBBF", "FB#BF", " BBB ", "     "}).aisle(new String[]{"     ", " BBB ", " B#B ", " BBB ", "     "}).aisle(new String[]{"FFFFF", "FBBBF", "FB#BF", " BBB ", "     "}).aisle(new String[]{"     ", " BBB ", " B#B ", " BBB ", "     "}).aisle(new String[]{"DDDDD", "DDSDD", "DDDDD", "DDDDD", "DDDDD"}).where('S', this.selfPredicate()).where('D', casingPredicate.or(this.autoAbilities(true, true, false, true, true, false, false))).where('C', casingPredicate.or(this.autoAbilities(false, false, true, false, false, true, false))).where('F', MetaTileEntitySinteringOven.frames((Material[])new Material[]{Materials.Steel})).where('B', SuSyPredicates.sinteringBricks()).where('#', MetaTileEntitySinteringOven.air()).where(' ', MetaTileEntitySinteringOven.any()).build();
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("SinteringBrickType");
        this.canUsePlasma = type instanceof BlockSinteringBrick.SinteringBrickType ? ((BlockSinteringBrick.SinteringBrickType)((Object)type)).canResistPlasma : false;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.canUsePlasma = false;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        return this.canUsePlasma || (Boolean)recipe.getProperty((RecipeProperty)SinterProperty.getInstance(), (Object)false) == false;
    }
}

