/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.metatileentity.multiblock.MetaTileEntityOrderedDT;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.common.blocks.BlockSuSyMultiblockCasing;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntitySieveDistillationTower
extends MetaTileEntityOrderedDT {
    public MetaTileEntitySieveDistillationTower(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.SIEVE_DISTILLATION_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntitySieveDistillationTower(this.metaTileEntityId);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        FluidStack stackInTank;
        if (this.isStructureFormed() && (stackInTank = this.importFluids.drain(Integer.MAX_VALUE, false)) != null && stackInTank.amount > 0) {
            ITextComponent fluidName = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation((FluidStack)stackInTank), (TextFormatting)TextFormatting.AQUA);
            textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.distillation_tower.distilling_fluid", (Object[])new Object[]{fluidName}));
        }
        super.addDisplayText(textList);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{"YSY", "YYY", "YYY"}).aisle(new String[]{"FXF", "X#X", "FXF"}).setRepeatable(1, 11).aisle(new String[]{"XXX", "XXX", "XXX"}).where('S', this.selfPredicate()).where('Y', MetaTileEntitySieveDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntitySieveDistillationTower.getCasingState()}).or(MetaTileEntitySieveDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setMaxGlobalLimited(1)).or(MetaTileEntitySieveDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntitySieveDistillationTower.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMinGlobalLimited(1).setMaxGlobalLimited(2))).where('X', MetaTileEntitySieveDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntitySieveDistillationTower.getCasingState()}).or(MetaTileEntitySieveDistillationTower.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])((List)MultiblockAbility.REGISTRY.get(MultiblockAbility.EXPORT_FLUIDS)).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new))).setMaxLayerLimited(1)).or(this.autoAbilities(true, false))).where('#', MetaTileEntitySieveDistillationTower.states((IBlockState[])new IBlockState[]{MetaTileEntitySieveDistillationTower.getSieveState()})).where('F', MetaTileEntitySieveDistillationTower.frames((Material[])new Material[]{Materials.StainlessSteel})).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.CLEAN_STAINLESS_STEEL_CASING;
    }

    protected static IBlockState getSieveState() {
        return SuSyBlocks.MULTIBLOCK_CASING.getState(BlockSuSyMultiblockCasing.CasingType.SIEVE_TRAY);
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.DISTILLATION_TOWER_OVERLAY;
    }
}

